/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.spi;

import jakarta.ws.rs.ConstrainedTo;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.SeBootstrap;
import jakarta.ws.rs.core.Application;
import org.glassfish.jersey.server.spi.WebServer;
import org.glassfish.jersey.spi.Contract;

@Contract
@ConstrainedTo(value=RuntimeType.SERVER)
public interface WebServerProvider {
    public <T extends WebServer> T createServer(Class<T> var1, Application var2, SeBootstrap.Configuration var3) throws ProcessingException;

    public <T extends WebServer> T createServer(Class<T> var1, Class<? extends Application> var2, SeBootstrap.Configuration var3) throws ProcessingException;

    public static <T extends WebServer> boolean isSupportedWebServer(Class<? extends WebServer> supportedType, Class<T> userType, SeBootstrap.Configuration configuration) {
        Object webServerObj = configuration.property("jersey.config.server.bootstrap.webserver.class");
        Class webServerCls = webServerObj == null || WebServer.class.equals(webServerObj) ? null : (Class)webServerObj;
        return webServerCls != null && webServerCls.isAssignableFrom(supportedType) || webServerCls == null && userType.isAssignableFrom(supportedType);
    }
}

