/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal.operations;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.validation.internal.Tracing;
import org.eclipse.wst.validation.internal.operations.IResourceUtil;
import org.eclipse.wst.validation.internal.operations.IWorkbenchContext;
import org.eclipse.wst.validation.internal.operations.ValidatorManager;
import org.eclipse.wst.validation.internal.operations.WorkbenchFileDelta;
import org.eclipse.wst.validation.internal.operations.WorkbenchReporter;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;

public class WorkbenchContext
implements IWorkbenchContext {
    private IProject _project;
    private Hashtable<String, Method> _modelRegistry = new Hashtable();
    private int _ruleGroup = 1;
    public List<String> validationFileURIs;
    public static final String GET_PROJECT_FILES = "getAllFiles";
    public static final String GET_FILE = "getFile";
    public static final String VALIDATION_MARKER = "com.ibm.etools.validation.problemmarker";
    public static final String VALIDATION_MARKER_OWNER = "owner";

    public WorkbenchContext() {
        this.registerModel("PASS_LEVEL", "loadRuleGroup");
        Class[] args = new Class[]{String.class};
        this.registerModel(GET_FILE, GET_FILE, args);
        this.registerModel(GET_PROJECT_FILES, "getFiles", args);
    }

    @Override
    public void cleanup(WorkbenchReporter reporter) {
    }

    @Override
    public void closing() {
        this.closing(this.getProject());
    }

    public void closing(IProject project) {
    }

    @Override
    public void deleting() {
        this.deleting(this.getProject());
    }

    public void deleting(IProject project) {
    }

    public static String getContainerRelativePath(String fullPath, IContainer container) {
        if (fullPath == null || container == null) {
            return null;
        }
        IPath relPath = WorkbenchContext.getContainerRelativePath((IPath)new Path(fullPath), container);
        if (relPath != null) {
            return relPath.toString();
        }
        return null;
    }

    public static IPath getContainerRelativePath(IResource resource, IContainer container) {
        if (resource == null || container == null) {
            return null;
        }
        IResource foundResource = null;
        IPath relPath = WorkbenchContext.getContainerRelativePath(resource.getFullPath(), container);
        if (relPath != null) {
            try {
                if (!resource.exists()) {
                    if (resource instanceof IFile) {
                        foundResource = container.getFile(relPath);
                    } else if (resource instanceof IFolder) {
                        foundResource = container.getFolder(relPath);
                    }
                } else {
                    foundResource = container.findMember(relPath, true);
                    if (foundResource != null && !foundResource.exists()) {
                        foundResource = null;
                    }
                }
            }
            catch (IllegalArgumentException e) {
                foundResource = null;
                ValidationPlugin.getPlugin().handleException(e);
            }
        }
        if (foundResource == null) {
            return null;
        }
        int matchingFirstSegments = container.getProjectRelativePath().matchingFirstSegments(resource.getProjectRelativePath());
        return resource.getProjectRelativePath().removeFirstSegments(matchingFirstSegments);
    }

    public static IPath getContainerRelativePath(IPath path, IContainer container) {
        if (path == null || container == null) {
            return null;
        }
        if (path.isAbsolute()) {
            int matchingFirstSegments = path.matchingFirstSegments(container.getFullPath());
            if (matchingFirstSegments > 0 && matchingFirstSegments == container.getFullPath().segmentCount()) {
                return path.removeFirstSegments(matchingFirstSegments);
            }
            return null;
        }
        return null;
    }

    public String getDescription(Object object) {
        WorkbenchFileDelta wfd;
        if (object == null) {
            return "";
        }
        if (object instanceof WorkbenchFileDelta && (wfd = (WorkbenchFileDelta)object).getResource() != null) {
            return wfd.getResource().getFullPath().toString();
        }
        return object.toString();
    }

    @Override
    public IFile getFile(Object obj) {
        return null;
    }

    @Override
    public IResource getResource(Object obj) {
        if (obj == null) {
            return null;
        }
        IResource res = null;
        if (obj instanceof WorkbenchFileDelta) {
            res = ((WorkbenchFileDelta)obj).getResource();
        } else if (obj instanceof IResource) {
            res = (IResource)obj;
        }
        if (res == null || !res.exists()) {
            return this.getFile(obj);
        }
        return res;
    }

    public int getLineNo(Object object) {
        IResourceUtil util = ValidatorManager.getResourceUtil();
        if (util == null) {
            return 0;
        }
        try {
            return util.getLineNo(object);
        }
        catch (Exception e) {
            ValidationPlugin.getPlugin().handleException(e);
            return 0;
        }
    }

    @Override
    public String getLocation(Object object) {
        IResource res = this.getResource(object);
        if (res == null || !(res instanceof IFile)) {
            return this.getDescription(object);
        }
        int lineNumber = this.getLineNo(object);
        if (lineNumber == 0) {
            return this.getDescription(object);
        }
        return String.valueOf(lineNumber);
    }

    private final Method getMethod(String methodName, Class[] parmTypes) {
        Method m = null;
        try {
            m = this.getClass().getMethod(methodName, parmTypes);
        }
        catch (NoSuchMethodException e) {
            ValidationPlugin.getPlugin().handleException(e);
            return null;
        }
        return m;
    }

    @Override
    public String getPortableName(IResource resource) {
        return resource.getFullPath().toString();
    }

    @Override
    public final IProject getProject() {
        return this._project;
    }

    public IFile getFile(String filename) {
        IResource res = this.getProject().findMember(filename, true);
        if (res instanceof IFile) {
            return (IFile)res;
        }
        return null;
    }

    public Collection<IFile> getFiles(String validatorClassName) {
        IProject project = this.getProject();
        ArrayList<IFile> files = new ArrayList<IFile>();
        this.getFiles(files, (IContainer)project, validatorClassName);
        return files;
    }

    protected void getFiles(Collection<IFile> files, IContainer resource, String validatorClassName) {
        try {
            IResource[] resourceArray = resource.members(false);
            int i = 0;
            while (i < resourceArray.length) {
                if (ValidatorManager.getManager().isApplicableTo(validatorClassName, resourceArray[i]) && resourceArray[i] instanceof IFile) {
                    files.add((IFile)resourceArray[i]);
                }
                if (resourceArray[i].getType() == 2) {
                    this.getFiles(files, (IContainer)resourceArray[i], validatorClassName);
                }
                ++i;
            }
        }
        catch (Exception exception) {}
    }

    public int getRuleGroup() {
        return this._ruleGroup;
    }

    public void initialize() {
    }

    public final boolean isRegistered(String symbolicName) {
        if (symbolicName == null) {
            return false;
        }
        return this._modelRegistry.containsKey(symbolicName);
    }

    @Override
    public Object loadModel(String symbolicName) {
        return this.loadModel(symbolicName, null);
    }

    @Override
    public Object loadModel(String symbolicName, Object[] parms) {
        Method loader;
        block6: {
            loader = this._modelRegistry.get(symbolicName);
            if (loader != null) break block6;
            return null;
        }
        try {
            return loader.invoke((Object)this, parms);
        }
        catch (IllegalAccessException e) {
            ValidationPlugin.getPlugin().handleException(e);
            return null;
        }
        catch (InvocationTargetException e) {
            ValidationPlugin.getPlugin().handleException(e);
            ValidationPlugin.getPlugin().handleException(e.getTargetException());
            return null;
        }
        catch (NullPointerException e) {
            ValidationPlugin.getPlugin().handleException(e);
            return null;
        }
        catch (ExceptionInInitializerError e) {
            ValidationPlugin.getPlugin().handleException(e);
            return null;
        }
    }

    public Object loadRuleGroup() {
        return new Integer(this.getRuleGroup());
    }

    public void setRuleGroup(int rg) {
        this._ruleGroup = rg;
    }

    protected final void registerModel(String symbolicName, String loadMethodName) {
        this.registerModel(symbolicName, loadMethodName, null);
    }

    protected final void registerModel(String symbolicName, String loadMethodName, Class[] parms) {
        Method method = this.getMethod(loadMethodName, parms);
        if (method == null) {
            if (Tracing.isLogging()) {
                StringBuffer buffer = new StringBuffer("WorkbenchContext-01: load method ");
                buffer.append(loadMethodName);
                buffer.append("(");
                int i = 0;
                while (parms != null && i < parms.length) {
                    buffer.append(parms[i]);
                    ++i;
                }
                buffer.append(") must exist. " + this.getClass().getName() + " cannot support model " + symbolicName);
                Tracing.log(buffer);
            }
        } else {
            this._modelRegistry.put(symbolicName, method);
        }
    }

    @Override
    public void registerResource(IResource resource) {
    }

    @Override
    public final void setProject(IProject project) {
        this._project = project;
        if (project != null) {
            this.initialize();
        }
    }

    @Override
    public void shutdown() {
        this.shutdown(this.getProject());
    }

    public void shutdown(IProject project) {
    }

    @Override
    public String getTargetObjectName(Object object) {
        return null;
    }

    @Override
    public String[] getURIs() {
        String[] uris = new String[this.validationFileURIs.size()];
        this.validationFileURIs.toArray(uris);
        return uris;
    }

    public List<String> getValidationFileURIs() {
        return this.validationFileURIs;
    }

    public void setValidationFileURIs(List<String> validationFileURIs) {
        this.validationFileURIs = validationFileURIs;
    }
}

