/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.repositories.http.core;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.mylyn.commons.repositories.http.core.CommonHttpResponse;

class CancellableInputStream
extends FilterInputStream {
    private volatile boolean cancelled;
    private final CommonHttpResponse response;

    public CancellableInputStream(CommonHttpResponse response, InputStream in) {
        super(in);
        Assert.isNotNull((Object)response);
        this.response = response;
    }

    @Override
    public int available() throws IOException {
        this.checkCancelled();
        try {
            return super.available();
        }
        catch (IOException e) {
            this.checkCancelled();
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        this.response.notifyStreamClosed();
        super.close();
    }

    void closeWithoutNotification() throws IOException {
        super.close();
    }

    @Override
    public int read() throws IOException {
        this.checkCancelled();
        try {
            return super.read();
        }
        catch (IOException e) {
            this.checkCancelled();
            throw e;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkCancelled();
        try {
            return super.read(b, off, len);
        }
        catch (IOException e) {
            this.checkCancelled();
            throw e;
        }
    }

    private void checkCancelled() {
        if (this.cancelled) {
            throw new OperationCanceledException();
        }
    }

    void cancel() {
        this.cancelled = true;
    }
}

