/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.internal.support;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.ISeriesSettings;
import org.eclipse.swtchart.extensions.core.SeriesLabelProvider;
import org.eclipse.swtchart.extensions.core.SeriesListUI;
import org.eclipse.swtchart.extensions.core.SeriesMapper;

public class SeriesComparator
extends ViewerComparator {
    private static final int DESCENDING = 1;
    private int propertyIndex = 0;
    private int direction = 1;

    public int getDirection() {
        return this.direction == 1 ? 1024 : 128;
    }

    public void setColumn(int column) {
        if (column == this.propertyIndex) {
            this.direction = 1 - this.direction;
        } else {
            this.propertyIndex = column;
            this.direction = 1;
        }
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int sortOrder = 0;
        if (e1 instanceof ISeries && e2 instanceof ISeries && viewer instanceof SeriesListUI) {
            SeriesListUI seriesListUI = (SeriesListUI)viewer;
            BaseChart baseChart = seriesListUI.getBaseChart();
            ISeries series1 = (ISeries)e1;
            ISeriesSettings seriesSettings1 = baseChart.getSeriesSettings(series1.getId());
            Color color1 = SeriesLabelProvider.getColor(seriesSettings1);
            ISeries series2 = (ISeries)e2;
            ISeriesSettings seriesSettings2 = baseChart.getSeriesSettings(series2.getId());
            Color color2 = SeriesLabelProvider.getColor(seriesSettings2);
            switch (this.propertyIndex) {
                case 0: {
                    sortOrder = series1.getId().compareTo(series2.getId());
                    break;
                }
                case 1: {
                    if (baseChart == null) break;
                    ISeriesSettings mapping1 = SeriesMapper.get(series1, baseChart);
                    ISeriesSettings mapping2 = SeriesMapper.get(series1, baseChart);
                    if (mapping1 != null && mapping2 == null) {
                        sortOrder = -1;
                        break;
                    }
                    if (mapping1 == null && mapping2 != null) {
                        sortOrder = 1;
                        break;
                    }
                    sortOrder = 0;
                    break;
                }
                case 2: {
                    sortOrder = Boolean.compare(series1.isVisible(), series2.isVisible());
                    break;
                }
                case 3: {
                    sortOrder = Boolean.compare(series1.isVisibleInLegend(), series2.isVisibleInLegend());
                    break;
                }
                case 4: {
                    sortOrder = color1 != null && color2 != null ? color1.toString().compareTo(color2.toString()) : 0;
                    break;
                }
                case 5: {
                    sortOrder = series1.getDescription().compareTo(series2.getDescription());
                    break;
                }
                default: {
                    sortOrder = 0;
                }
            }
        }
        if (this.direction == 1) {
            sortOrder = -sortOrder;
        }
        return sortOrder;
    }
}

