/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.discovery;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.util.StringUtils;
import org.eclipse.ecf.discovery.AbstractDiscoveryContainerAdapter;
import org.eclipse.ecf.discovery.IServiceListener;
import org.eclipse.ecf.discovery.IServiceTypeListener;
import org.eclipse.ecf.discovery.identity.IServiceIDFactory;
import org.eclipse.ecf.discovery.identity.IServiceTypeID;
import org.eclipse.ecf.discovery.identity.ServiceIDFactory;
import org.eclipse.ecf.internal.discovery.DiscoveryPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class DiscoveryServiceListener
implements ServiceListener {
    private final AbstractDiscoveryContainerAdapter discoveryContainer;
    private final Class listenerClass;
    private final BundleContext context;
    private final IServiceIDFactory idFactory;
    private final Namespace discoveryNamespace;

    public DiscoveryServiceListener(AbstractDiscoveryContainerAdapter anAbstractDiscoveryContainerAdapter, Class clazz) {
        this.discoveryContainer = anAbstractDiscoveryContainerAdapter;
        this.listenerClass = clazz;
        this.discoveryNamespace = IDFactory.getDefault().getNamespaceByName("ecf.namespace.discovery");
        this.idFactory = ServiceIDFactory.getDefault();
        this.context = DiscoveryPlugin.getDefault().getBundleContext();
        try {
            ServiceReference[] references = this.context.getServiceReferences(this.listenerClass.getName(), null);
            this.addServiceListener(references);
            this.context.addServiceListener((ServiceListener)this, this.getFilter());
        }
        catch (InvalidSyntaxException e) {
            DiscoveryPlugin.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.discovery", 4, "Cannot create filter", (Throwable)e));
        }
    }

    public void dispose() {
        if (!DiscoveryPlugin.isStopped()) {
            this.context.removeServiceListener((ServiceListener)this);
        }
    }

    private void addServiceListener(ServiceReference[] references) {
        if (references == null) {
            return;
        }
        int i = 0;
        while (i < references.length) {
            Object aListener;
            ServiceReference serviceReference = references[i];
            if (this.listenerClass.getName().equals(IServiceListener.class.getName())) {
                if (this.isAllWildcards(serviceReference)) {
                    aListener = (IServiceListener)this.context.getService(serviceReference);
                    this.discoveryContainer.addServiceListener((IServiceListener)aListener);
                } else {
                    IServiceTypeID aType = this.getIServiceTypeID(serviceReference);
                    if (aType != null) {
                        IServiceListener aListener2 = (IServiceListener)this.context.getService(serviceReference);
                        this.discoveryContainer.addServiceListener(aType, aListener2);
                    }
                }
            } else {
                aListener = (IServiceTypeListener)this.context.getService(serviceReference);
                this.discoveryContainer.addServiceTypeListener((IServiceTypeListener)aListener);
            }
            ++i;
        }
    }

    private void addServiceListener(ServiceReference reference) {
        this.addServiceListener(new ServiceReference[]{reference});
    }

    private void removeServiceListener(ServiceReference[] references) {
        if (references == null) {
            return;
        }
        int i = 0;
        while (i < references.length) {
            Object aListener;
            ServiceReference serviceReference = references[i];
            if (this.listenerClass.getName().equals(IServiceListener.class.getName())) {
                if (this.isAllWildcards(serviceReference)) {
                    aListener = (IServiceListener)this.context.getService(serviceReference);
                    this.discoveryContainer.removeServiceListener((IServiceListener)aListener);
                } else {
                    IServiceTypeID aType = this.getIServiceTypeID(serviceReference);
                    if (aType != null) {
                        IServiceListener aListener2 = (IServiceListener)this.context.getService(serviceReference);
                        this.discoveryContainer.removeServiceListener(aType, aListener2);
                    }
                }
            } else {
                aListener = (IServiceTypeListener)this.context.getService(serviceReference);
                this.discoveryContainer.removeServiceTypeListener((IServiceTypeListener)aListener);
            }
            ++i;
        }
    }

    private void removeServiceListener(ServiceReference reference) {
        this.removeServiceListener(new ServiceReference[]{reference});
    }

    private boolean isAllWildcards(ServiceReference serviceReference) {
        return serviceReference.getProperty("org.eclipse.ecf.discovery.namingauthority") == null && serviceReference.getProperty("org.eclipse.ecf.discovery.services") == null && serviceReference.getProperty("org.eclipse.ecf.discovery.scopes") == null && serviceReference.getProperty("org.eclipse.ecf.discovery.protocols") == null;
    }

    private IServiceTypeID getIServiceTypeID(ServiceReference serviceReference) {
        String namingAuthority = (String)serviceReference.getProperty("org.eclipse.ecf.discovery.namingauthority");
        if (namingAuthority == null) {
            namingAuthority = "*";
        }
        try {
            IServiceTypeID createServiceTypeID = this.idFactory.createServiceTypeID(this.discoveryNamespace, this.convert(serviceReference, "org.eclipse.ecf.discovery.services"), this.convert(serviceReference, "org.eclipse.ecf.discovery.scopes"), this.convert(serviceReference, "org.eclipse.ecf.discovery.protocols"), namingAuthority);
            return createServiceTypeID;
        }
        catch (IDCreateException e) {
            return null;
        }
    }

    private String[] convert(ServiceReference serviceReference, String key) {
        Object value = serviceReference.getProperty(key);
        if (value == null) {
            return new String[]{"*"};
        }
        if (value instanceof String[]) {
            return (String[])value;
        }
        return StringUtils.split((String)((String)value), (String)"._");
    }

    public void serviceChanged(ServiceEvent event) {
        Object containerName = event.getServiceReference().getProperty("org.eclipse.ecf.discovery.containerName");
        if (!this.discoveryContainer.getContainerName().equals(containerName)) {
            return;
        }
        switch (event.getType()) {
            case 1: {
                this.addServiceListener(event.getServiceReference());
                break;
            }
            case 4: {
                this.removeServiceListener(event.getServiceReference());
                break;
            }
        }
    }

    private String getFilter() {
        return "(objectClass=" + this.listenerClass.getName() + ")";
    }
}

