/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.parser.builder.event;

import java.util.Objects;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.builder.event.DocumentBuilderEvent;

public class ImageEvent
extends DocumentBuilderEvent {
    private final String url;
    private final Attributes attributes;

    public ImageEvent(Attributes attributes, String url) {
        this.url = Objects.requireNonNull(url, "Must provide an url");
        this.attributes = Objects.requireNonNull(attributes, "Must provide attributes").clone();
    }

    @Override
    public void invoke(DocumentBuilder builder) {
        builder.image(this.attributes, this.url);
    }

    public int hashCode() {
        return Objects.hash(this.url);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ImageEvent)) {
            return false;
        }
        return Objects.equals(this.url, ((ImageEvent)obj).url);
    }

    public String toString() {
        return String.format("image(%s)", this.url);
    }
}

