/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers;

import org.eclipse.cdt.codan.core.cxx.model.AbstractIndexAstChecker;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExpression;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.internal.core.dom.parser.ValueFactory;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class FloatCompareChecker
extends AbstractIndexAstChecker {
    public static final String ERR_ID = "org.eclipse.cdt.codan.internal.checkers.FloatCompareProblem";

    public void processAst(IASTTranslationUnit ast) {
        ast.accept(new ASTVisitor(){
            {
                this.shouldVisitExpressions = true;
            }

            private boolean equals(IASTExpression expr1, IASTExpression expr2) {
                IBinding rightLeftBinding;
                IBinding leftLeftBinding;
                if (expr1 instanceof ICPPASTExpression && expr2 instanceof ICPPASTExpression) {
                    return ((ICPPASTExpression)expr1).getEvaluation().isEquivalentTo(((ICPPASTExpression)expr2).getEvaluation());
                }
                if (expr1 instanceof IASTIdExpression && expr2 instanceof IASTIdExpression) {
                    IBinding rightLeftBinding2;
                    IBinding leftLeftBinding2 = ((IASTIdExpression)expr1).getName().resolveBinding();
                    if (CPPVisitor.areEquivalentBindings((IBinding)leftLeftBinding2, (IBinding)(rightLeftBinding2 = ((IASTIdExpression)expr2).getName().resolveBinding()), (IIndex)expr1.getTranslationUnit().getIndex())) {
                        return true;
                    }
                } else if (expr1 instanceof IASTLiteralExpression && expr2 instanceof IASTLiteralExpression) {
                    Number n1 = ValueFactory.getConstantNumericalValue((IASTExpression)expr1);
                    Number n2 = ValueFactory.getConstantNumericalValue((IASTExpression)expr2);
                    if (n1 != null && n1.equals(n2)) {
                        return true;
                    }
                } else if (expr1 instanceof IASTFieldReference && expr2 instanceof IASTFieldReference && CPPVisitor.areEquivalentBindings((IBinding)(leftLeftBinding = ((IASTFieldReference)expr1).getFieldName().resolveBinding()), (IBinding)(rightLeftBinding = ((IASTFieldReference)expr2).getFieldName().resolveBinding()), (IIndex)expr1.getTranslationUnit().getIndex())) {
                    return true;
                }
                return false;
            }

            private boolean processDirect(IASTBinaryExpression expression) {
                IASTBinaryExpression binary = expression;
                if ((binary.getOperator() == 29 || binary.getOperator() == 28) && (FloatCompareChecker.this.isFloat(binary.getOperand1().getExpressionType()) || FloatCompareChecker.this.isFloat(binary.getOperand2().getExpressionType()))) {
                    FloatCompareChecker.this.reportProblem(FloatCompareChecker.ERR_ID, (IASTNode)expression, new Object[0]);
                    return true;
                }
                return false;
            }

            private boolean processIndirect(IASTBinaryExpression binary) {
                if (binary.getOperator() == 15) {
                    return this.processIndirect(binary, false);
                }
                if (binary.getOperator() == 16) {
                    return this.processIndirect(binary, true);
                }
                return false;
            }

            private boolean processIndirect(IASTBinaryExpression expression, boolean invert) {
                int cond1Test = 10;
                int cond2Test = 11;
                if (invert) {
                    cond1Test = 8;
                    cond2Test = 9;
                }
                IASTBinaryExpression binary = expression;
                IASTExpression left = binary.getOperand1();
                IASTExpression right = binary.getOperand2();
                if (left instanceof IASTBinaryExpression && right instanceof IASTBinaryExpression) {
                    int leftOp = ((IASTBinaryExpression)left).getOperator();
                    int rightOp = ((IASTBinaryExpression)right).getOperator();
                    if (leftOp == cond1Test && rightOp == cond2Test || rightOp == cond1Test && leftOp == cond2Test) {
                        IASTExpression leftLeft = ((IASTBinaryExpression)left).getOperand1();
                        IASTExpression leftRight = ((IASTBinaryExpression)left).getOperand2();
                        IASTExpression rightLeft = ((IASTBinaryExpression)right).getOperand1();
                        IASTExpression rightRight = ((IASTBinaryExpression)right).getOperand2();
                        if (this.equals(leftLeft, rightLeft) && this.equals(leftRight, rightRight) && (FloatCompareChecker.this.isFloat(leftLeft.getExpressionType()) || FloatCompareChecker.this.isFloat(leftRight.getExpressionType()))) {
                            FloatCompareChecker.this.reportProblem(FloatCompareChecker.ERR_ID, (IASTNode)expression, new Object[0]);
                            return true;
                        }
                    }
                }
                return false;
            }

            public int visit(IASTExpression expression) {
                boolean res;
                if (expression instanceof IASTBinaryExpression && !(res = this.processDirect((IASTBinaryExpression)expression))) {
                    boolean bl = this.processIndirect((IASTBinaryExpression)expression);
                }
                return 3;
            }
        });
    }

    private boolean isFloat(IType type) {
        if (!((type = SemanticUtil.getNestedType((IType)type, (int)21)) instanceof IBasicType)) {
            return false;
        }
        IBasicType.Kind k = ((IBasicType)type).getKind();
        switch (k) {
            case eFloat: 
            case eDouble: 
            case eFloat128: {
                return true;
            }
        }
        return false;
    }
}

