/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.terminal.internal.model;

import org.eclipse.terminal.internal.model.TerminalTextDataStore;
import org.eclipse.terminal.model.ITerminalTextData;
import org.eclipse.terminal.model.ITerminalTextDataSnapshot;
import org.eclipse.terminal.model.LineSegment;
import org.eclipse.terminal.model.TerminalStyle;

public class TerminalTextDataFastScroll
implements ITerminalTextData {
    final ITerminalTextData fData;
    private int fHeight;
    private int fMaxHeight;
    int fOffset;

    public TerminalTextDataFastScroll(ITerminalTextData data, int maxHeight) {
        this.fMaxHeight = maxHeight;
        this.fData = data;
        this.fData.setDimensions(maxHeight, this.fData.getWidth());
        if (maxHeight > 2) assert (this.shiftOffset(-2) || this.throwRuntimeException());
    }

    public TerminalTextDataFastScroll(int maxHeight) {
        this(new TerminalTextDataStore(), maxHeight);
    }

    public TerminalTextDataFastScroll() {
        this(new TerminalTextDataStore(), 1);
    }

    private boolean throwRuntimeException() {
        throw new RuntimeException();
    }

    int getPositionOfLine(int line) {
        return (line + this.fOffset) % this.fMaxHeight;
    }

    void moveOffset(int delta) {
        assert (Math.abs(delta) < this.fMaxHeight || this.throwRuntimeException());
        this.fOffset = (this.fMaxHeight + this.fOffset + delta) % this.fMaxHeight;
    }

    private boolean shiftOffset(int shift) {
        this.moveOffset(shift);
        return true;
    }

    @Override
    public void addLine() {
        if (this.getHeight() < this.fMaxHeight) {
            this.setDimensions(this.getHeight() + 1, this.getWidth());
        } else {
            this.scroll(0, this.getHeight(), -1);
        }
    }

    @Override
    public void cleanLine(int line) {
        this.fData.cleanLine(this.getPositionOfLine(line));
    }

    @Override
    public void copy(ITerminalTextData source) {
        int n = source.getHeight();
        this.setDimensions(source.getHeight(), source.getWidth());
        int i = 0;
        while (i < n) {
            this.fData.copyLine(source, i, this.getPositionOfLine(i));
            ++i;
        }
    }

    @Override
    public void copyLine(ITerminalTextData source, int sourceLine, int destLine) {
        this.fData.copyLine(source, sourceLine, this.getPositionOfLine(destLine));
    }

    @Override
    public void copyRange(ITerminalTextData source, int sourceStartLine, int destStartLine, int length) {
        assert (destStartLine >= 0 && destStartLine + length <= this.fHeight || this.throwRuntimeException());
        int i = 0;
        while (i < length) {
            this.fData.copyLine(source, i + sourceStartLine, this.getPositionOfLine(i + destStartLine));
            ++i;
        }
    }

    @Override
    public char getChar(int line, int column) {
        assert (line >= 0 && line < this.fHeight || this.throwRuntimeException());
        return this.fData.getChar(this.getPositionOfLine(line), column);
    }

    @Override
    public char[] getChars(int line) {
        assert (line >= 0 && line < this.fHeight || this.throwRuntimeException());
        return this.fData.getChars(this.getPositionOfLine(line));
    }

    @Override
    public int getHeight() {
        return this.fHeight;
    }

    @Override
    public LineSegment[] getLineSegments(int line, int startCol, int numberOfCols) {
        assert (line >= 0 && line < this.fHeight || this.throwRuntimeException());
        return this.fData.getLineSegments(this.getPositionOfLine(line), startCol, numberOfCols);
    }

    @Override
    public int getMaxHeight() {
        return this.fMaxHeight;
    }

    @Override
    public TerminalStyle getStyle(int line, int column) {
        assert (line >= 0 && line < this.fHeight || this.throwRuntimeException());
        return this.fData.getStyle(this.getPositionOfLine(line), column);
    }

    @Override
    public TerminalStyle[] getStyles(int line) {
        assert (line >= 0 && line < this.fHeight || this.throwRuntimeException());
        return this.fData.getStyles(this.getPositionOfLine(line));
    }

    @Override
    public int getWidth() {
        return this.fData.getWidth();
    }

    @Override
    public ITerminalTextDataSnapshot makeSnapshot() {
        return this.fData.makeSnapshot();
    }

    private void cleanLines(int line, int len) {
        int i = line;
        while (i < line + len) {
            this.fData.cleanLine(this.getPositionOfLine(i));
            ++i;
        }
    }

    @Override
    public void scroll(int startLine, int size, int shift) {
        assert (startLine >= 0 && startLine + size <= this.fHeight || this.throwRuntimeException());
        if (shift >= this.fMaxHeight || -shift >= this.fMaxHeight) {
            this.cleanLines(startLine, this.fMaxHeight - startLine);
            return;
        }
        if (size == this.fHeight) {
            this.moveOffset(-shift);
            if (shift < 0) {
                this.cleanLines(Math.max(startLine, startLine + size + shift), Math.min(-shift, this.getHeight() - startLine));
            } else {
                this.cleanLines(startLine, Math.min(shift, this.getHeight() - startLine));
            }
        } else if (shift < 0) {
            int i = startLine;
            while (i < startLine + size + shift) {
                this.fData.copyLine(this.fData, this.getPositionOfLine(i - shift), this.getPositionOfLine(i));
                ++i;
            }
            this.cleanLines(Math.max(0, startLine + size + shift), Math.min(-shift, this.getHeight() - startLine));
        } else {
            int i = startLine + size - 1;
            while (i >= startLine && i - shift >= 0) {
                this.fData.copyLine(this.fData, this.getPositionOfLine(i - shift), this.getPositionOfLine(i));
                --i;
            }
            this.cleanLines(startLine, Math.min(shift, this.getHeight() - startLine));
        }
    }

    @Override
    public void setChar(int line, int column, char c, TerminalStyle style) {
        assert (line >= 0 && line < this.fHeight || this.throwRuntimeException());
        this.fData.setChar(this.getPositionOfLine(line), column, c, style);
    }

    @Override
    public void setChars(int line, int column, char[] chars, int start, int len, TerminalStyle style) {
        assert (line >= 0 && line < this.fHeight || this.throwRuntimeException());
        this.fData.setChars(this.getPositionOfLine(line), column, chars, start, len, style);
    }

    @Override
    public void setChars(int line, int column, char[] chars, TerminalStyle style) {
        assert (line >= 0 && line < this.fHeight || this.throwRuntimeException());
        this.fData.setChars(this.getPositionOfLine(line), column, chars, style);
    }

    @Override
    public void setDimensions(int height, int width) {
        assert (height >= 0 || this.throwRuntimeException());
        assert (width >= 0 || this.throwRuntimeException());
        if (height > this.fMaxHeight) {
            this.setMaxHeight(height);
        }
        this.fHeight = height;
        if (width != this.fData.getWidth()) {
            this.fData.setDimensions(this.fMaxHeight, width);
        }
    }

    @Override
    public void setMaxHeight(int maxHeight) {
        assert (maxHeight >= this.fHeight || this.throwRuntimeException());
        int start = this.getPositionOfLine(0);
        if (start != 0) {
            TerminalTextDataStore buffer = new TerminalTextDataStore();
            buffer.setDimensions(maxHeight, this.getWidth());
            int n = Math.min(this.fMaxHeight - start, maxHeight);
            buffer.copyRange(this.fData, start, 0, n);
            if (n < maxHeight) {
                buffer.copyRange(this.fData, 0, n, Math.min(this.fMaxHeight - n, maxHeight - n));
            }
            this.fData.copy(buffer);
            this.shiftOffset(-start);
        } else {
            this.fData.setDimensions(maxHeight, this.fData.getWidth());
        }
        this.fMaxHeight = maxHeight;
    }

    @Override
    public int getCursorColumn() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getCursorLine() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCursorColumn(int column) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCursorLine(int line) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWrappedLine(int line) {
        assert (line >= 0 && line < this.fHeight || this.throwRuntimeException());
        return this.fData.isWrappedLine(this.getPositionOfLine(line));
    }

    @Override
    public void setWrappedLine(int line) {
        assert (line >= 0 && line < this.fHeight || this.throwRuntimeException());
        this.fData.setWrappedLine(this.getPositionOfLine(line));
    }
}

