/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.util.BytesRef;

public class MultiFacetQuery
extends TermInSetQuery {
    public MultiFacetQuery(FacetsConfig facetsConfig, String dimension, String[] ... paths) {
        super(facetsConfig.getDimConfig((String)dimension).indexFieldName, MultiFacetQuery.toTerms(dimension, paths));
    }

    public MultiFacetQuery(String dimension, String[] ... paths) {
        super(FacetsConfig.DEFAULT_DIM_CONFIG.indexFieldName, MultiFacetQuery.toTerms(dimension, paths));
    }

    static Collection<BytesRef> toTerms(String dimension, String[] ... paths) {
        ArrayList<BytesRef> terms = new ArrayList<BytesRef>(paths.length);
        for (String[] path : paths) {
            terms.add(new BytesRef((CharSequence)FacetsConfig.pathToString(dimension, path)));
        }
        return terms;
    }
}

