/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.rpmlint.builder;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.linuxtools.internal.rpm.rpmlint.parser.RpmlintParser;

public class RpmlintDeltaVisitor
implements IResourceDeltaVisitor {
    private List<String> paths = new ArrayList<String>();

    public boolean visit(IResourceDelta delta) {
        IResource resource = delta.getResource();
        if ("spec".equals(resource.getFileExtension()) || "rpm".equals(resource.getFileExtension())) {
            switch (delta.getKind()) {
                case 1: {
                    this.paths.add(resource.getLocation().toOSString());
                    break;
                }
                case 4: {
                    RpmlintParser.deleteMarkers(resource);
                    this.paths.add(resource.getLocation().toOSString());
                }
            }
        }
        return true;
    }

    public List<String> getVisitedPaths() {
        return this.paths;
    }
}

