/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.callstack;

import com.google.common.collect.Multimap;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.callstack.CallstackXmlAnalysis;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfAnalysisModuleHelperXml;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModuleHelper;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAnalysisManager;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.w3c.dom.Element;

public class CallstackXmlModuleHelper
extends TmfAnalysisModuleHelperXml {
    private final ISubModuleHelper fHelper;

    public CallstackXmlModuleHelper(File xmlFile, Element node) {
        super(xmlFile, node, TmfAnalysisModuleHelperXml.XmlAnalysisModuleType.OTHER);
        List<Element> childElements = TmfXmlUtils.getChildElements(node, "pattern");
        if (!childElements.isEmpty()) {
            this.fHelper = new HiddenModuleHelper(new TmfAnalysisModuleHelperXml(xmlFile, childElements.get(0), TmfAnalysisModuleHelperXml.XmlAnalysisModuleType.PATTERN));
            return;
        }
        childElements = TmfXmlUtils.getChildElements(node, "stateProvider");
        if (!childElements.isEmpty()) {
            this.fHelper = new HiddenModuleHelper(new TmfAnalysisModuleHelperXml(xmlFile, childElements.get(0), TmfAnalysisModuleHelperXml.XmlAnalysisModuleType.STATE_SYSTEM));
            return;
        }
        childElements = TmfXmlUtils.getChildElements(node, "analysis");
        if (childElements.isEmpty()) {
            throw new IllegalStateException("XML callstack element: there should be one of {pattern, stateProvider, analysis}. none found");
        }
        this.fHelper = new RefModuleHelper(String.valueOf(childElements.get(0).getAttribute("id")));
    }

    @Override
    protected IAnalysisModule createOtherModule(String analysisid, String name) {
        CallstackXmlAnalysis module = new CallstackXmlAnalysis(Objects.requireNonNull(this.getSourceFile()), this.fHelper);
        module.setId(analysisid);
        module.setName(name);
        return module;
    }

    @Override
    public String getName() {
        return this.fHelper.getHelpers().stream().map(h -> h.getName()).findFirst().get();
    }

    @Override
    @NonNullByDefault(value={})
    public boolean appliesToTraceType(Class<? extends ITmfTrace> traceClass) {
        List collect = this.fHelper.getHelpers().stream().filter(h -> h.appliesToTraceType(traceClass)).collect(Collectors.toList());
        return !collect.isEmpty();
    }

    static class HiddenModuleHelper
    implements ISubModuleHelper {
        private final IAnalysisModuleHelper fHelper;

        public HiddenModuleHelper(IAnalysisModuleHelper helper) {
            this.fHelper = helper;
        }

        @Override
        public Collection<IAnalysisModuleHelper> getHelpers() {
            return Collections.singleton(this.fHelper);
        }

        @Override
        public @Nullable IAnalysisModule getAnalysis(ITmfTrace trace) {
            try {
                return this.fHelper.newModule(trace);
            }
            catch (TmfAnalysisException e) {
                Activator.logError(e.getMessage());
                return null;
            }
        }
    }

    static interface ISubModuleHelper {
        public Collection<IAnalysisModuleHelper> getHelpers();

        public @Nullable IAnalysisModule getAnalysis(ITmfTrace var1);
    }

    static class RefModuleHelper
    implements ISubModuleHelper {
        private final String fAnalysisId;

        public RefModuleHelper(String id) {
            this.fAnalysisId = id;
        }

        @Override
        public @NonNull Collection<IAnalysisModuleHelper> getHelpers() {
            Multimap analysisModules = TmfAnalysisManager.getAnalysisModules();
            Collection collection = analysisModules.get((Object)this.fAnalysisId);
            if (collection.isEmpty()) {
                Activator.logWarning("Callstack XML analysis: no analysis called " + this.fAnalysisId);
            }
            return collection;
        }

        @Override
        public @Nullable IAnalysisModule getAnalysis(ITmfTrace trace) {
            return trace.getAnalysisModule(this.fAnalysisId);
        }
    }
}

