/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.edit.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.mylyn.reviews.core.model.IFileVersion;
import org.eclipse.mylyn.reviews.edit.provider.ReviewItemItemProvider;
import org.eclipse.mylyn.reviews.internal.core.model.ReviewsPackage;

public class FileVersionItemProvider
extends ReviewItemItemProvider
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    public FileVersionItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addPathPropertyDescriptor(object);
            this.addDescriptionPropertyDescriptor(object);
            this.addContentPropertyDescriptor(object);
            this.addFilePropertyDescriptor(object);
            this.addFileRevisionPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addPathPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_FileVersion_path_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_FileVersion_path_feature", "_UI_FileVersion_type"), (EStructuralFeature)ReviewsPackage.Literals.FILE_VERSION__PATH, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addDescriptionPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_FileVersion_description_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_FileVersion_description_feature", "_UI_FileVersion_type"), (EStructuralFeature)ReviewsPackage.Literals.FILE_VERSION__DESCRIPTION, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addContentPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_FileVersion_content_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_FileVersion_content_feature", "_UI_FileVersion_type"), (EStructuralFeature)ReviewsPackage.Literals.FILE_VERSION__CONTENT, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addFilePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_FileVersion_file_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_FileVersion_file_feature", "_UI_FileVersion_type"), (EStructuralFeature)ReviewsPackage.Literals.FILE_VERSION__FILE, true, false, true, null, null, null));
    }

    protected void addFileRevisionPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_FileVersion_fileRevision_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_FileVersion_fileRevision_feature", "_UI_FileVersion_type"), (EStructuralFeature)ReviewsPackage.Literals.FILE_VERSION__FILE_REVISION, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    @Override
    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/FileVersion"));
    }

    @Override
    public String getText(Object object) {
        IFileVersion version = (IFileVersion)object;
        String label = version.getId();
        return label == null || label.length() == 0 ? this.getString("_UI_FileVersion_type") : label;
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(IFileVersion.class)) {
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    @Override
    public String getCreateChildText(Object owner, Object feature, Object child, Collection<?> selection) {
        boolean qualify;
        Object childFeature = feature;
        Object childObject = child;
        boolean bl = qualify = childFeature == ReviewsPackage.Literals.COMMENT_CONTAINER__COMMENTS || childFeature == ReviewsPackage.Literals.COMMENT_CONTAINER__DRAFTS;
        if (qualify) {
            return this.getString("_UI_CreateChild_text2", new Object[]{this.getTypeText(childObject), this.getFeatureText(childFeature), this.getTypeText(owner)});
        }
        return super.getCreateChildText(owner, feature, child, selection);
    }
}

