/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.tcmodification.extension;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.IRealBuildObjectAssociation;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.IObjectSet;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.Messages;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.ObjectSet;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.ObjectSetList;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.PerTypeMapStorage;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.TcModificationUtil;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.extension.ConflictDefinition;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.extension.ConflictDefinitionElement;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.extension.MatchObjectElement;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.extension.ObjectSetListBasedDefinition;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class RulesManager {
    private static RulesManager fInstance;
    private static final String EXTENSION_POINT_ID;
    private ConflictDefinition[] fConflictDefinitions;
    private Map<MatchObjectElement, IObjectSet> fMatchObjectMap = new HashMap<MatchObjectElement, IObjectSet>();
    private PerTypeMapStorage<IRealBuildObjectAssociation, Set<IRealBuildObjectAssociation>> fObjToChildSuperClassMap;
    private StarterJob fStarter;
    private boolean fIsStartInited;

    static {
        EXTENSION_POINT_ID = ManagedBuilderCorePlugin.getUniqueIdentifier() + ".tcModificationInfo";
    }

    private RulesManager() {
    }

    public static RulesManager getInstance() {
        if (fInstance == null) {
            fInstance = RulesManager.getInstanceSynch();
        }
        return fInstance;
    }

    public static synchronized RulesManager getInstanceSynch() {
        if (fInstance == null) {
            fInstance = new RulesManager();
        }
        return fInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.fIsStartInited) {
            return;
        }
        RulesManager rulesManager = this;
        synchronized (rulesManager) {
            if (this.fIsStartInited) {
                return;
            }
            this.fIsStartInited = true;
        }
        this.fStarter = new StarterJob();
        this.fStarter.schedule();
    }

    private void loadExtensions() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_ID);
        if (extensionPoint == null) {
            this.fConflictDefinitions = new ConflictDefinition[0];
        } else {
            IExtension[] extensions = extensionPoint.getExtensions();
            ArrayList<ConflictDefinition> conflictDefs = new ArrayList<ConflictDefinition>();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                int k = 0;
                while (k < elements.length) {
                    IConfigurationElement el = elements[k];
                    String elName = el.getName();
                    if ("conflictDefinition".equals(elName)) {
                        try {
                            ConflictDefinitionElement cde = new ConflictDefinitionElement(el);
                            ConflictDefinition cd = this.resolve(cde);
                            if (cd != null) {
                                conflictDefs.add(cd);
                            }
                        }
                        catch (IllegalArgumentException e) {
                            ManagedBuilderCorePlugin.log(e);
                        }
                    }
                    ++k;
                }
                ++i;
            }
            this.fConflictDefinitions = conflictDefs.toArray(new ConflictDefinition[conflictDefs.size()]);
        }
    }

    private ConflictDefinition resolve(ConflictDefinitionElement el) throws IllegalArgumentException {
        MatchObjectElement[] mos = el.getMatchObjects();
        if (mos.length != 2) {
            throw new IllegalArgumentException();
        }
        IObjectSet[] oss = new IObjectSet[mos.length];
        int i = 0;
        while (i < mos.length) {
            oss[i] = this.resolve(mos[i]);
            if (oss[i].getNumObjects() == 0) {
                return null;
            }
            ++i;
        }
        return new ConflictDefinition(new ObjectSetList(oss));
    }

    private IObjectSet resolve(MatchObjectElement el) {
        IObjectSet oSet = this.fMatchObjectMap.get(el);
        if (oSet == null) {
            int type = el.getObjectType();
            MatchObjectElement.PatternElement[] patterns = el.getPatterns();
            HashSet<IRealBuildObjectAssociation> objectsSet = new HashSet<IRealBuildObjectAssociation>();
            int i = 0;
            while (i < patterns.length) {
                MatchObjectElement.PatternElement pattern = patterns[i];
                this.processPattern(type, pattern, objectsSet);
                ++i;
            }
            oSet = new ObjectSet(type, objectsSet);
            this.fMatchObjectMap.put(el, oSet);
        }
        return oSet;
    }

    private IRealBuildObjectAssociation[] getObjectsForId(int objType, String id, int idType) {
        if (idType == 256) {
            IRealBuildObjectAssociation obj = TcModificationUtil.getObjectById(objType, id);
            if (obj != null) {
                return new IRealBuildObjectAssociation[]{obj};
            }
            return new IRealBuildObjectAssociation[0];
        }
        IRealBuildObjectAssociation[] allObjs = TcModificationUtil.getExtensionObjects(objType);
        Pattern pattern = Pattern.compile(id);
        ArrayList<IRealBuildObjectAssociation> list = new ArrayList<IRealBuildObjectAssociation>();
        int i = 0;
        while (i < allObjs.length) {
            if (pattern.matcher(allObjs[i].getId()).matches()) {
                list.add(allObjs[i]);
            }
            ++i;
        }
        return list.toArray(new IRealBuildObjectAssociation[list.size()]);
    }

    private Set<IRealBuildObjectAssociation> processPattern(int objType, MatchObjectElement.PatternElement el, Set<IRealBuildObjectAssociation> set) {
        block6: {
            String[] ids;
            block5: {
                if (set == null) {
                    set = new HashSet<IRealBuildObjectAssociation>();
                }
                ids = el.getIds();
                if (el.getSearchType() != 1) break block5;
                int i = 0;
                while (i < ids.length) {
                    IRealBuildObjectAssociation[] objs = this.getObjectsForId(objType, ids[i], el.getIdType());
                    int k = 0;
                    while (k < objs.length) {
                        set.add(objs[k].getRealBuildObject());
                        ++k;
                    }
                    ++i;
                }
                break block6;
            }
            if (el.getSearchType() != 2) break block6;
            IRealBuildObjectAssociation[] allReal = TcModificationUtil.getRealObjects(objType);
            int i = 0;
            while (i < ids.length) {
                IRealBuildObjectAssociation[] objs = this.getObjectsForId(objType, ids[i], el.getIdType());
                int k = 0;
                while (k < objs.length) {
                    IRealBuildObjectAssociation obj = objs[k];
                    set.add(obj.getRealBuildObject());
                    Set<IRealBuildObjectAssociation> childRealSet = this.getChildSuperClassRealSet(obj, allReal);
                    set.addAll(childRealSet);
                    ++k;
                }
                ++i;
            }
        }
        return set;
    }

    private Set<IRealBuildObjectAssociation> getChildSuperClassRealSet(IRealBuildObjectAssociation obj, IRealBuildObjectAssociation[] all) {
        Map<IRealBuildObjectAssociation, Set<IRealBuildObjectAssociation>> map;
        Set<IRealBuildObjectAssociation> set;
        if (this.fObjToChildSuperClassMap == null) {
            this.fObjToChildSuperClassMap = new PerTypeMapStorage();
        }
        if (all == null) {
            all = TcModificationUtil.getExtensionObjects(obj.getType());
        }
        if ((set = (map = this.fObjToChildSuperClassMap.getMap(obj.getType(), true)).get(obj)) == null) {
            set = RulesManager.createChildSuperClassRealSet(obj, all, null);
            map.put(obj, set);
        }
        return set;
    }

    private static Set<IRealBuildObjectAssociation> createChildSuperClassRealSet(IRealBuildObjectAssociation obj, IRealBuildObjectAssociation[] all, Set<IRealBuildObjectAssociation> set) {
        if (set == null) {
            set = new HashSet<IRealBuildObjectAssociation>();
        }
        if (all == null) {
            all = TcModificationUtil.getExtensionObjects(obj.getType());
        }
        int i = 0;
        while (i < all.length) {
            IRealBuildObjectAssociation cur = all[i];
            IRealBuildObjectAssociation el = cur.getSuperClassObject();
            while (el != null) {
                if (el == obj) {
                    IRealBuildObjectAssociation realQuickTest = null;
                    IRealBuildObjectAssociation found = cur;
                    while (found != obj) {
                        IRealBuildObjectAssociation real = found.getRealBuildObject();
                        if (real != realQuickTest) {
                            set.add(real);
                            realQuickTest = real;
                        }
                        found = found.getSuperClassObject();
                    }
                }
                el = el.getSuperClassObject();
            }
            ++i;
        }
        return set;
    }

    public ObjectSetListBasedDefinition[] getRules(int ruleType) {
        this.checkInitialization();
        return (ObjectSetListBasedDefinition[])this.fConflictDefinitions.clone();
    }

    private void checkInitialization() {
        if (!this.fIsStartInited) {
            throw new IllegalStateException();
        }
        StarterJob starter = this.fStarter;
        if (starter != null) {
            try {
                starter.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private class StarterJob
    extends Job {
        private StarterJob() {
            super(Messages.getString("RulesManager.1"));
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                RulesManager.this.loadExtensions();
            }
            finally {
                RulesManager.this.fStarter = null;
            }
            return Status.OK_STATUS;
        }
    }
}

