/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.dataprovider;

import org.eclipse.cdt.core.cdtvariables.ICdtVariable;
import org.eclipse.cdt.core.cdtvariables.ICdtVariableManager;
import org.eclipse.cdt.core.cdtvariables.ICdtVariablesContributor;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.BuildConfigurationData;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.ExternalExtensionMacroSupplier;
import org.eclipse.cdt.managedbuilder.internal.macros.DefaultMacroContextInfo;
import org.eclipse.cdt.managedbuilder.internal.macros.MbsMacroSupplier;
import org.eclipse.cdt.utils.cdtvariables.ICdtVariableSupplier;
import org.eclipse.cdt.utils.cdtvariables.IVariableContextInfo;
import org.eclipse.cdt.utils.cdtvariables.SupplierBasedCdtVariableManager;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;

public class BuildVariablesContributor
implements ICdtVariablesContributor {
    private BuildConfigurationData fCfgData;

    BuildVariablesContributor(BuildConfigurationData data) {
        this.fCfgData = data;
    }

    public ICdtVariable getVariable(String name, ICdtVariableManager provider) {
        ContributorMacroContextInfo info = this.createContextInfo(provider);
        if (info != null) {
            return SupplierBasedCdtVariableManager.getVariable((String)name, (IVariableContextInfo)info, (boolean)true);
        }
        return null;
    }

    private ContributorMacroContextInfo createContextInfo(ICdtVariableManager mngr) {
        IConfiguration cfg = this.fCfgData.getConfiguration();
        if (((Configuration)cfg).isPreference()) {
            return null;
        }
        ICConfigurationDescription cfgDes = ManagedBuildManager.getDescriptionForConfiguration(cfg);
        if (cfgDes != null) {
            return new ContributorMacroContextInfo(mngr, cfgDes, 3, cfg);
        }
        return null;
    }

    public ICdtVariable[] getVariables(ICdtVariableManager provider) {
        ContributorMacroContextInfo info = this.createContextInfo(provider);
        if (info != null) {
            return SupplierBasedCdtVariableManager.getVariables((IVariableContextInfo)info, (boolean)true);
        }
        return null;
    }

    private class ContributorMacroContextInfo
    extends DefaultMacroContextInfo {
        ICdtVariableManager fMngr;
        private ICConfigurationDescription fCfgDes;

        public ContributorMacroContextInfo(ICdtVariableManager mngr, ICConfigurationDescription cfgDes, int type, Object data) {
            super(type, data);
            this.fMngr = mngr;
            this.fCfgDes = cfgDes;
        }

        @Override
        protected ICdtVariableSupplier[] getSuppliers(int type, Object data) {
            switch (type) {
                case 3: {
                    return new ICdtVariableSupplier[]{new ExternalExtensionMacroSupplier(this.fMngr, this.fCfgDes), MbsMacroSupplier.getInstance()};
                }
                case 4: {
                    return new ICdtVariableSupplier[]{new ExternalExtensionMacroSupplier(this.fMngr, this.fCfgDes), MbsMacroSupplier.getInstance()};
                }
                case 5: {
                    return new ICdtVariableSupplier[]{MbsMacroSupplier.getInstance()};
                }
            }
            return null;
        }

        @Override
        public IVariableContextInfo getNext() {
            switch (this.getContextType()) {
                case 3: {
                    IManagedProject managedProject;
                    Object data = this.getContextData();
                    IConfiguration configuration = null;
                    if (data instanceof IBuilder) {
                        configuration = ((IBuilder)data).getParent().getParent();
                    } else if (data instanceof IConfiguration) {
                        configuration = (IConfiguration)data;
                    }
                    if (configuration == null || (managedProject = configuration.getManagedProject()) == null) break;
                    return new ContributorMacroContextInfo(this.fMngr, this.fCfgDes, 4, managedProject);
                }
                case 4: {
                    IWorkspace wsp;
                    Object data = this.getContextData();
                    if (!(data instanceof IManagedProject) || (wsp = ResourcesPlugin.getWorkspace()) == null) break;
                    return new ContributorMacroContextInfo(this.fMngr, this.fCfgDes, 5, wsp);
                }
                case 5: {
                    if (!(this.getContextData() instanceof IWorkspace)) break;
                    return new ContributorMacroContextInfo(this.fMngr, this.fCfgDes, 6, null);
                }
            }
            return null;
        }
    }
}

