/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.core;

import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Locale;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.internal.commons.core.XmlStringConverter;
import org.eclipse.mylyn.internal.context.core.AggregateInteractionEvent;
import org.eclipse.mylyn.internal.context.core.IInteractionContextWriter;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class SaxContextWriter
implements IInteractionContextWriter {
    private OutputStream outputStream;

    @Override
    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public void writeContextToStream(IInteractionContext context) throws IOException {
        if (this.outputStream == null) {
            IOException ioe = new IOException("OutputStream not set");
            throw ioe;
        }
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(new SAXSource(new SaxWriter(), new InteractionContextInputSource(context)), new StreamResult(this.outputStream));
        }
        catch (TransformerException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.core", "Could not write context", (Throwable)e));
            throw new IOException(e.getMessage());
        }
    }

    private Attributes createEventAttributes(InteractionEvent ie) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S z", Locale.ENGLISH);
        AttributesImpl ieAttributes = new AttributesImpl();
        ieAttributes.addAttribute("", "Delta", "Delta", "", XmlStringConverter.convertToXmlString((String)ie.getDelta()));
        ieAttributes.addAttribute("", "EndDate", "EndDate", "", dateFormat.format(ie.getEndDate()));
        ieAttributes.addAttribute("", "Interest", "Interest", "", Float.toString(ie.getInterestContribution()));
        ieAttributes.addAttribute("", "Kind", "Kind", "", ie.getKind().toString());
        ieAttributes.addAttribute("", "Navigation", "Navigation", "", XmlStringConverter.convertToXmlString((String)ie.getNavigation()));
        ieAttributes.addAttribute("", "OriginId", "OriginId", "", XmlStringConverter.convertToXmlString((String)ie.getOriginId()));
        ieAttributes.addAttribute("", "StartDate", "StartDate", "", dateFormat.format(ie.getDate()));
        ieAttributes.addAttribute("", "StructureHandle", "StructureHandle", "", XmlStringConverter.convertToXmlString((String)ie.getStructureHandle()));
        ieAttributes.addAttribute("", "StructureKind", "StructureKind", "", XmlStringConverter.convertToXmlString((String)ie.getStructureKind()));
        if (ie instanceof AggregateInteractionEvent) {
            ieAttributes.addAttribute("", "NumEvents", "NumEvents", "", Integer.toString(((AggregateInteractionEvent)ie).getNumCollapsedEvents()));
            ieAttributes.addAttribute("", "CreationCount", "CreationCount", "", Integer.toString(((AggregateInteractionEvent)ie).getEventCountOnCreation()));
        }
        return ieAttributes;
    }

    private static class InteractionContextInputSource
    extends InputSource {
        private final IInteractionContext context;

        public InteractionContextInputSource(IInteractionContext context) {
            this.context = context;
        }

        public IInteractionContext getContext() {
            return this.context;
        }
    }

    private class SaxWriter
    implements XMLReader {
        private ContentHandler handler;
        private ErrorHandler errorHandler;

        private SaxWriter() {
        }

        @Override
        public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
            return false;
        }

        @Override
        public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        }

        @Override
        public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
            return null;
        }

        @Override
        public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        }

        @Override
        public void setEntityResolver(EntityResolver resolver) {
        }

        @Override
        public EntityResolver getEntityResolver() {
            return null;
        }

        @Override
        public void setDTDHandler(DTDHandler handler) {
        }

        @Override
        public DTDHandler getDTDHandler() {
            return null;
        }

        @Override
        public void setContentHandler(ContentHandler handler) {
            this.handler = handler;
        }

        @Override
        public ContentHandler getContentHandler() {
            return this.handler;
        }

        @Override
        public void setErrorHandler(ErrorHandler handler) {
            this.errorHandler = handler;
        }

        @Override
        public ErrorHandler getErrorHandler() {
            return this.errorHandler;
        }

        @Override
        public void parse(InputSource input) throws IOException, SAXException {
            if (!(input instanceof InteractionContextInputSource)) {
                throw new SAXException("Can only parse writable input sources");
            }
            IInteractionContext context = ((InteractionContextInputSource)input).getContext();
            this.handler.startDocument();
            AttributesImpl rootAttributes = new AttributesImpl();
            rootAttributes.addAttribute("", "Id", "Id", "", context.getHandleIdentifier());
            if (context.getContentLimitedTo() != null) {
                rootAttributes.addAttribute("", "Content", "Content", "", context.getContentLimitedTo());
            }
            rootAttributes.addAttribute("", "Version", "Version", "", "1");
            this.handler.startElement("", "InteractionHistory", "InteractionHistory", rootAttributes);
            for (InteractionEvent ie : context.getInteractionHistory()) {
                Attributes ieAttributes = SaxContextWriter.this.createEventAttributes(ie);
                this.handler.startElement("", "InteractionEvent", "InteractionEvent", ieAttributes);
                this.handler.endElement("", "InteractionEvent", "InteractionEvent");
            }
            this.handler.endElement("", "InteractionHistory", "InteractionHistory");
            this.handler.endDocument();
        }

        @Override
        public void parse(String systemId) throws IOException, SAXException {
            throw new SAXException("Can only parse writable input sources");
        }
    }
}

