/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.event.aspect;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataType;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.traceeventlogger.LogUtils;

public class MultiAspect<T>
implements ITmfEventAspect<T> {
    private static final Logger LOGGER = TraceCompassLog.getLogger(MultiAspect.class);
    private final String fName;
    private final Iterable<ITmfEventAspect<?>> fAspects;

    public static @Nullable ITmfEventAspect<?> create(Iterable<ITmfEventAspect<?>> aspects, Class<?> aspectClass) {
        StringJoiner sj;
        int size = Iterables.size(aspects);
        if (size == 0 || size == 1) {
            return (ITmfEventAspect)Iterables.getFirst(aspects, null);
        }
        HashSet<String> names = new HashSet<String>();
        HashSet<DataType> dataTypes = new HashSet<DataType>();
        for (ITmfEventAspect<?> aspect : aspects) {
            if (aspectClass.isAssignableFrom(aspect.getClass())) {
                names.add(aspect.getName());
                dataTypes.add(aspect.getDataType());
                continue;
            }
            throw new IllegalArgumentException("Aspects must belong to the same class as the \"aspectClass\" parameter.");
        }
        if (names.size() != 1) {
            sj = new StringJoiner(", ");
            names.forEach(sj::add);
            LogUtils.traceInstant((Logger)LOGGER, (Level)Level.WARNING, (String)"Aspects do not have the same name: ", (Object[])new Object[]{sj.toString()});
        }
        if (dataTypes.size() != 1) {
            sj = new StringJoiner(", ");
            dataTypes.forEach(dt -> {
                StringJoiner stringJoiner2 = sj.add(dt.toString());
            });
            LogUtils.traceInstant((Logger)LOGGER, (Level)Level.WARNING, (String)"Aspects do not have the same data type: ", (Object[])new Object[]{sj.toString()});
        }
        return new MultiAspect((String)Iterables.get(names, (int)0), aspects);
    }

    public static ITmfEventAspect<?> createFrom(ITmfEventAspect<?> existing, ITmfEventAspect<?> toAdd) {
        ITmfEventAspect subclassOwner;
        if (toAdd instanceof MultiAspect) {
            throw new IllegalArgumentException(String.format("\"%s\" as the to-add parameter cannot be a MultiAspect.", toAdd.getName()));
        }
        ArrayList aspects = new ArrayList();
        if (existing instanceof MultiAspect) {
            MultiAspect multi = (MultiAspect)existing;
            for (ITmfEventAspect<?> each : multi.fAspects) {
                aspects.add(each);
            }
            subclassOwner = (ITmfEventAspect)aspects.get(0);
        } else {
            aspects.add(existing);
            subclassOwner = existing;
        }
        aspects.add(toAdd);
        Class<?> aspectClass = MultiAspect.assignableFor(subclassOwner, toAdd);
        ITmfEventAspect createdFrom = MultiAspect.create(aspects, aspectClass);
        if (createdFrom == null) {
            createdFrom = existing;
        }
        return createdFrom;
    }

    private static Class<?> assignableFor(ITmfEventAspect<?> subclassOwner, ITmfEventAspect<?> toAdd) {
        Class<?> candidate = subclassOwner.getClass();
        Class<?> superclass = candidate.getSuperclass();
        while (superclass != null && !candidate.isAssignableFrom(toAdd.getClass())) {
            candidate = superclass;
            superclass = candidate.getSuperclass();
        }
        return candidate;
    }

    private MultiAspect(String name, Iterable<ITmfEventAspect<?>> aspects) {
        this.fName = name;
        this.fAspects = aspects;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public String getHelpText() {
        return ((ITmfEventAspect)Iterables.get(this.fAspects, (int)0)).getHelpText();
    }

    @Override
    public @Nullable T resolve(ITmfEvent event) {
        for (ITmfEventAspect<?> aspect : this.fAspects) {
            Object resolve = aspect.resolve(event);
            if (resolve == null) continue;
            return (T)resolve;
        }
        return null;
    }

    @Override
    public DataType getDataType() {
        Iterator<ITmfEventAspect<?>> iterator = this.fAspects.iterator();
        if (iterator.hasNext()) {
            ITmfEventAspect<?> aspect = iterator.next();
            return aspect.getDataType();
        }
        return ITmfEventAspect.super.getDataType();
    }
}

