/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.tmf.core.model;

import com.google.common.base.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataType;
import org.eclipse.tracecompass.tmf.core.model.ITableColumnDescriptor;

public class TableColumnDescriptor
implements ITableColumnDescriptor {
    private final String fText;
    private final String fTooltipText;
    private final DataType fDataType;

    private TableColumnDescriptor(Builder builder) {
        this.fText = builder.fText;
        this.fTooltipText = builder.fTooltipText;
        this.fDataType = builder.fDataType;
    }

    @Override
    public String getText() {
        return this.fText;
    }

    @Override
    public String getTooltip() {
        return this.fTooltipText;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ITableColumnDescriptor)) {
            return false;
        }
        ITableColumnDescriptor other = (ITableColumnDescriptor)obj;
        return Objects.equal((Object)this.fText, (Object)other.getText()) && Objects.equal((Object)this.fTooltipText, (Object)other.getTooltip()) && Objects.equal((Object)((Object)this.fDataType), (Object)((Object)other.getDataType()));
    }

    @Override
    public DataType getDataType() {
        return this.fDataType;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.fText, this.fTooltipText, this.fDataType});
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[text=").append(this.fText).append(" tooltip=").append(this.fTooltipText).append(" dataType=").append(this.fDataType.toString()).append("]");
        return builder.toString();
    }

    public static class Builder {
        private String fText = "";
        private String fTooltipText = "";
        private DataType fDataType = DataType.STRING;

        public Builder setText(String text) {
            this.fText = text;
            return this;
        }

        public Builder setTooltip(String tooltip) {
            this.fTooltipText = tooltip;
            return this;
        }

        public Builder setDataType(DataType dataType) {
            this.fDataType = dataType;
            return this;
        }

        public TableColumnDescriptor build() {
            return new TableColumnDescriptor(this);
        }
    }
}

