/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.openon;

import com.ibm.icu.util.StringTokenizer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.openon.IOpenOn;
import org.eclipse.wst.sse.ui.internal.openon.OpenOnProvider;
import org.eclipse.wst.sse.ui.internal.util.EditorUtility;

public class OpenFileHyperlinkTracker
implements KeyListener,
MouseListener,
MouseMoveListener,
FocusListener,
PaintListener,
IPropertyChangeListener,
IDocumentListener,
ITextInputListener {
    private boolean fActive;
    private IRegion fActiveRegion;
    private String fBrowserLikeLinksKeyModifierKey;
    private Color fColor;
    private Cursor fCursor;
    private int fKeyModifierMask;
    private String fLinkColorKey;
    private IPreferenceStore fPreferenceStore;
    private Position fRememberedPosition;
    private ITextViewer fTextViewer;

    public OpenFileHyperlinkTracker(ITextViewer textViewer) {
        this.fTextViewer = textViewer;
    }

    private void activateCursor(ITextViewer viewer) {
        StyledText text = viewer.getTextWidget();
        if (text == null || text.isDisposed()) {
            return;
        }
        Display display = text.getDisplay();
        if (this.fCursor == null) {
            this.fCursor = new Cursor((Device)display, 21);
        }
        text.setCursor(this.fCursor);
    }

    private int computeStateMask(String modifiers) {
        if (modifiers == null) {
            return -1;
        }
        if (modifiers.length() == 0) {
            return 0;
        }
        int stateMask = 0;
        StringTokenizer modifierTokenizer = new StringTokenizer(modifiers, ",;.:+-* ");
        while (modifierTokenizer.hasMoreTokens()) {
            int modifier = EditorUtility.findLocalizedModifier(modifierTokenizer.nextToken());
            if (modifier == 0 || (stateMask & modifier) == modifier) {
                return -1;
            }
            stateMask |= modifier;
        }
        return stateMask;
    }

    private Color createColor(IPreferenceStore store, String key, Display display) {
        RGB rgb = null;
        if (store.contains(key)) {
            rgb = store.isDefault(key) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key) : PreferenceConverter.getColor((IPreferenceStore)store, (String)key);
        }
        return EditorUtility.getColor(rgb);
    }

    public void deactivate() {
        this.deactivate(false);
    }

    public void deactivate(boolean redrawAll) {
        if (!this.fActive) {
            return;
        }
        this.repairRepresentation(redrawAll);
        this.fActive = false;
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
        if (this.fActive && this.fActiveRegion != null) {
            this.fRememberedPosition = new Position(this.fActiveRegion.getOffset(), this.fActiveRegion.getLength());
            try {
                event.getDocument().addPosition(this.fRememberedPosition);
            }
            catch (BadLocationException badLocationException) {
                this.fRememberedPosition = null;
            }
        }
    }

    public void documentChanged(DocumentEvent event) {
        if (this.fRememberedPosition != null) {
            if (!this.fRememberedPosition.isDeleted()) {
                StyledText widget;
                event.getDocument().removePosition(this.fRememberedPosition);
                this.fActiveRegion = new Region(this.fRememberedPosition.getOffset(), this.fRememberedPosition.getLength());
                this.fRememberedPosition = null;
                ITextViewer viewer = this.getTextViewer();
                if (viewer != null && (widget = viewer.getTextWidget()) != null && !widget.isDisposed()) {
                    widget.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            OpenFileHyperlinkTracker.this.deactivate();
                        }
                    });
                }
            } else {
                this.fActiveRegion = null;
                this.fRememberedPosition = null;
                this.deactivate();
            }
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent event) {
        this.deactivate();
    }

    private int getCurrentTextOffset() {
        StyledText text;
        block4: {
            try {
                text = this.getTextViewer().getTextWidget();
                if (text != null && !text.isDisposed()) break block4;
                return -1;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return -1;
            }
        }
        Display display = text.getDisplay();
        Point absolutePosition = display.getCursorLocation();
        Point relativePosition = text.toControl(absolutePosition);
        int widgetOffset = text.getOffsetAtLocation(relativePosition);
        if (this.getTextViewer() instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)this.getTextViewer();
            return extension.widgetOffset2ModelOffset(widgetOffset);
        }
        return widgetOffset + this.getTextViewer().getVisibleRegion().getOffset();
    }

    private Point getMaximumLocation(StyledText text, int offset, int length) {
        Point maxLocation = new Point(Integer.MIN_VALUE, Integer.MIN_VALUE);
        int i = 0;
        while (i <= length) {
            Point location = text.getLocationAtOffset(offset + i);
            if (location.x > maxLocation.x) {
                maxLocation.x = location.x;
            }
            if (location.y > maxLocation.y) {
                maxLocation.y = location.y;
            }
            ++i;
        }
        return maxLocation;
    }

    private Point getMinimumLocation(StyledText text, int offset, int length) {
        Point minLocation = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
        int i = 0;
        while (i <= length) {
            Point location = text.getLocationAtOffset(offset + i);
            if (location.x < minLocation.x) {
                minLocation.x = location.x;
            }
            if (location.y < minLocation.y) {
                minLocation.y = location.y;
            }
            ++i;
        }
        return minLocation;
    }

    private IPreferenceStore getNewPreferenceStore() {
        return this.fPreferenceStore;
    }

    private ITextViewer getTextViewer() {
        return this.fTextViewer;
    }

    private void highlightRegion(ITextViewer viewer, IRegion region) {
        if (region.equals(this.fActiveRegion)) {
            return;
        }
        this.repairRepresentation();
        StyledText text = viewer.getTextWidget();
        if (text == null || text.isDisposed()) {
            return;
        }
        int offset = 0;
        int length = 0;
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
            IRegion widgetRange = extension.modelRange2WidgetRange((IRegion)new Region(region.getOffset(), region.getLength()));
            if (widgetRange == null) {
                return;
            }
            offset = widgetRange.getOffset();
            length = widgetRange.getLength();
        } else {
            offset = region.getOffset() - viewer.getVisibleRegion().getOffset();
            length = region.getLength();
        }
        text.redrawRange(offset, length, true);
        this.fActiveRegion = region;
    }

    private boolean includes(IRegion region, IRegion position) {
        return position.getOffset() >= region.getOffset() && position.getOffset() + position.getLength() <= region.getOffset() + region.getLength();
    }

    public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        if (oldInput == null) {
            return;
        }
        this.deactivate();
        oldInput.removeDocumentListener((IDocumentListener)this);
    }

    public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
        if (newInput == null) {
            return;
        }
        newInput.addDocumentListener((IDocumentListener)this);
    }

    public void install(IPreferenceStore store) {
        this.fPreferenceStore = store;
        ITextViewer textViewer = this.getTextViewer();
        if (textViewer == null) {
            return;
        }
        StyledText text = textViewer.getTextWidget();
        if (text == null || text.isDisposed()) {
            return;
        }
        this.updateColor(textViewer);
        textViewer.addTextInputListener((ITextInputListener)this);
        IDocument document = textViewer.getDocument();
        if (document != null) {
            document.addDocumentListener((IDocumentListener)this);
        }
        text.addKeyListener((KeyListener)this);
        text.addMouseListener((MouseListener)this);
        text.addMouseMoveListener((MouseMoveListener)this);
        text.addFocusListener((FocusListener)this);
        text.addPaintListener((PaintListener)this);
        this.updateKeyModifierMask();
        this.fPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void keyPressed(KeyEvent event) {
        if (this.fActive) {
            this.deactivate();
            return;
        }
        if (event.keyCode != this.fKeyModifierMask) {
            this.deactivate();
            return;
        }
        this.fActive = true;
    }

    public void keyReleased(KeyEvent event) {
        if (!this.fActive) {
            return;
        }
        this.deactivate();
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent event) {
        if (!this.fActive) {
            return;
        }
        if (event.stateMask != this.fKeyModifierMask) {
            this.deactivate();
            return;
        }
        if (event.button != 1) {
            this.deactivate();
            return;
        }
    }

    public void mouseMove(MouseEvent event) {
        ITextViewer viewer;
        if (event.widget instanceof Control && !((Control)event.widget).isFocusControl()) {
            this.deactivate();
            return;
        }
        if (!this.fActive) {
            if (event.stateMask != this.fKeyModifierMask) {
                return;
            }
            this.fActive = true;
        }
        if ((viewer = this.getTextViewer()) == null) {
            this.deactivate();
            return;
        }
        StyledText text = viewer.getTextWidget();
        if (text == null || text.isDisposed()) {
            this.deactivate();
            return;
        }
        if ((event.stateMask & 0x80000) != 0 && text.getSelectionCount() != 0) {
            this.deactivate();
            return;
        }
        IRegion region = null;
        int offset = this.getCurrentTextOffset();
        IOpenOn openOn = OpenOnProvider.getInstance().getOpenOn(this.getTextViewer().getDocument(), offset);
        if (openOn != null) {
            region = openOn.getOpenOnRegion(this.getTextViewer().getDocument(), offset);
        }
        if (region == null || region.getLength() == 0) {
            this.repairRepresentation();
            return;
        }
        this.highlightRegion(viewer, region);
        this.activateCursor(viewer);
    }

    public void mouseUp(MouseEvent e) {
        IOpenOn openOn;
        if (!this.fActive) {
            return;
        }
        if (e.button != 1) {
            this.deactivate();
            return;
        }
        boolean wasActive = this.fCursor != null;
        IRegion previousRegion = this.fActiveRegion;
        this.deactivate();
        if (wasActive && (openOn = OpenOnProvider.getInstance().getOpenOn(this.getTextViewer().getDocument(), previousRegion.getOffset())) != null) {
            openOn.openOn(this.getTextViewer().getDocument(), previousRegion);
        }
    }

    public void paintControl(PaintEvent event) {
        if (this.fActiveRegion == null) {
            return;
        }
        ITextViewer viewer = this.getTextViewer();
        if (viewer == null) {
            return;
        }
        StyledText text = viewer.getTextWidget();
        if (text == null || text.isDisposed()) {
            return;
        }
        int offset = 0;
        int length = 0;
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
            IRegion widgetRange = extension.modelRange2WidgetRange(this.fActiveRegion);
            if (widgetRange == null) {
                return;
            }
            offset = widgetRange.getOffset();
            length = widgetRange.getLength();
        } else {
            IRegion region = viewer.getVisibleRegion();
            if (!this.includes(region, this.fActiveRegion)) {
                return;
            }
            offset = this.fActiveRegion.getOffset() - region.getOffset();
            length = this.fActiveRegion.getLength();
        }
        Point minLocation = this.getMinimumLocation(text, offset, length);
        Point maxLocation = this.getMaximumLocation(text, offset, length);
        int x1 = minLocation.x;
        int x2 = minLocation.x + maxLocation.x - minLocation.x - 1;
        int y = minLocation.y + text.getLineHeight() - 1;
        GC gc = event.gc;
        if (this.fColor != null && !this.fColor.isDisposed()) {
            gc.setForeground(this.fColor);
        }
        gc.drawLine(x1, y, x2, y);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(this.fLinkColorKey)) {
            ITextViewer viewer = this.getTextViewer();
            if (viewer != null) {
                this.updateColor(viewer);
            }
        } else if (event.getProperty().equals(this.fBrowserLikeLinksKeyModifierKey)) {
            this.updateKeyModifierMask();
        }
    }

    private void repairRepresentation() {
        this.repairRepresentation(false);
    }

    private void repairRepresentation(boolean redrawAll) {
        if (this.fActiveRegion == null) {
            return;
        }
        int offset = this.fActiveRegion.getOffset();
        int length = this.fActiveRegion.getLength();
        this.fActiveRegion = null;
        ITextViewer viewer = this.getTextViewer();
        if (viewer != null) {
            this.resetCursor(viewer);
            if (viewer instanceof ITextViewerExtension5) {
                ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
                offset = extension.modelOffset2WidgetOffset(offset);
            } else {
                offset -= viewer.getVisibleRegion().getOffset();
            }
            try {
                StyledText text = viewer.getTextWidget();
                text.redrawRange(offset, length, true);
            }
            catch (IllegalArgumentException x) {
                Logger.logException(x);
            }
        }
    }

    private void resetCursor(ITextViewer viewer) {
        StyledText text = viewer.getTextWidget();
        if (text != null && !text.isDisposed()) {
            text.setCursor(null);
        }
        if (this.fCursor != null) {
            this.fCursor.dispose();
            this.fCursor = null;
        }
    }

    public void setHyperlinkPreferenceKeys(String linkColorKey, String browserLikeLinksKeyModifierKey) {
        this.fLinkColorKey = linkColorKey;
        this.fBrowserLikeLinksKeyModifierKey = browserLikeLinksKeyModifierKey;
    }

    public void uninstall() {
        StyledText text;
        IPreferenceStore preferenceStore;
        ITextViewer textViewer;
        if (this.fCursor != null) {
            this.fCursor.dispose();
            this.fCursor = null;
        }
        if ((textViewer = this.getTextViewer()) == null) {
            return;
        }
        textViewer.removeTextInputListener((ITextInputListener)this);
        IDocument document = textViewer.getDocument();
        if (document != null) {
            document.removeDocumentListener((IDocumentListener)this);
        }
        if ((preferenceStore = this.getNewPreferenceStore()) != null) {
            preferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        if ((text = textViewer.getTextWidget()) == null || text.isDisposed()) {
            return;
        }
        text.removeKeyListener((KeyListener)this);
        text.removeMouseListener((MouseListener)this);
        text.removeMouseMoveListener((MouseMoveListener)this);
        text.removeFocusListener((FocusListener)this);
        text.removePaintListener((PaintListener)this);
    }

    private void updateColor(ITextViewer viewer) {
        StyledText text = viewer.getTextWidget();
        if (text == null || text.isDisposed()) {
            return;
        }
        Display display = text.getDisplay();
        this.fColor = this.createColor(this.getNewPreferenceStore(), this.fLinkColorKey, display);
    }

    private void updateKeyModifierMask() {
        String modifiers = this.getNewPreferenceStore().getString(this.fBrowserLikeLinksKeyModifierKey);
        this.fKeyModifierMask = this.computeStateMask(modifiers);
    }
}

