/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.model.ICAddressBreakpoint;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICBreakpoint2;
import org.eclipse.cdt.debug.core.model.ICDynamicPrintf;
import org.eclipse.cdt.debug.core.model.ICEventBreakpoint;
import org.eclipse.cdt.debug.core.model.ICFunctionBreakpoint;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.core.model.ICTracepoint;
import org.eclipse.cdt.debug.core.model.ICWatchpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CAddressBreakpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CAddressDynamicPrintf;
import org.eclipse.cdt.debug.internal.core.breakpoints.CAddressTracepoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CEventBreakpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CFunctionBreakpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CFunctionDynamicPrintf;
import org.eclipse.cdt.debug.internal.core.breakpoints.CFunctionTracepoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CLineBreakpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CLineDynamicPrintf;
import org.eclipse.cdt.debug.internal.core.breakpoints.CLineTracepoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CWatchpoint;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;

public class CDIDebugModel {
    public static String getPluginIdentifier() {
        return CDebugCorePlugin.getUniqueIdentifier();
    }

    public static String calculateMarkerType(IBreakpoint bp) {
        if (bp instanceof ICBreakpoint2) {
            return ((ICBreakpoint2)bp).getMarkerType();
        }
        if (bp instanceof ICDynamicPrintf) {
            if (bp instanceof ICFunctionBreakpoint) {
                return "org.eclipse.cdt.debug.core.cFunctionDynamicPrintfMarker";
            }
            if (bp instanceof ICAddressBreakpoint) {
                return "org.eclipse.cdt.debug.core.cAddressDynamicPrintfMarker";
            }
            if (bp instanceof ICLineBreakpoint) {
                return "org.eclipse.cdt.debug.core.cLineDynamicPrintfMarker";
            }
            return "org.eclipse.cdt.debug.core.cDynamicPrintfMarker";
        }
        if (bp instanceof ICTracepoint) {
            if (bp instanceof ICFunctionBreakpoint) {
                return "org.eclipse.cdt.debug.core.cFunctionTracepointMarker";
            }
            if (bp instanceof ICAddressBreakpoint) {
                return "org.eclipse.cdt.debug.core.cAddressTracepointMarker";
            }
            if (bp instanceof ICLineBreakpoint) {
                return "org.eclipse.cdt.debug.core.cLineTracepointMarker";
            }
            return "org.eclipse.cdt.debug.core.cTracepointMarker";
        }
        if (bp instanceof ICFunctionBreakpoint) {
            return "org.eclipse.cdt.debug.core.cFunctionBreakpointMarker";
        }
        if (bp instanceof ICAddressBreakpoint) {
            return "org.eclipse.cdt.debug.core.cAddressBreakpointMarker";
        }
        if (bp instanceof ICLineBreakpoint) {
            return "org.eclipse.cdt.debug.core.cLineBreakpointMarker";
        }
        if (bp instanceof ICEventBreakpoint) {
            return "org.eclipse.cdt.debug.core.cEventBreakpointMarker";
        }
        if (bp instanceof ICBreakpoint) {
            return "org.eclipse.cdt.debug.core.cBreakpointMarker";
        }
        if (bp instanceof ILineBreakpoint) {
            return IBreakpoint.LINE_BREAKPOINT_MARKER;
        }
        return IBreakpoint.BREAKPOINT_MARKER;
    }

    @Deprecated
    public static ICLineBreakpoint createLineBreakpoint(String sourceHandle, IResource resource, int lineNumber, boolean enabled, int ignoreCount, String condition, boolean register) throws CoreException {
        return CDIDebugModel.createLineBreakpoint(sourceHandle, resource, 0, lineNumber, enabled, ignoreCount, condition, register);
    }

    public static ICLineBreakpoint createLineBreakpoint(String sourceHandle, IResource resource, int type, int lineNumber, boolean enabled, int ignoreCount, String condition, boolean register) throws CoreException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        CDIDebugModel.setLineBreakpointAttributes(attributes, sourceHandle, type, lineNumber, enabled, ignoreCount, condition);
        return new CLineBreakpoint(resource, attributes, register);
    }

    public static ICLineBreakpoint createBlankLineBreakpoint() {
        return new CLineBreakpoint();
    }

    public static ICLineBreakpoint createLineTracepoint(String sourceHandle, IResource resource, int type, int lineNumber, boolean enabled, int ignoreCount, String condition, boolean register) throws CoreException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        CDIDebugModel.setLineBreakpointAttributes(attributes, sourceHandle, type, lineNumber, enabled, ignoreCount, condition);
        return new CLineTracepoint(resource, attributes, register);
    }

    public static ICLineBreakpoint createBlankLineTracepoint() {
        return new CLineTracepoint();
    }

    public static ICLineBreakpoint createLineDynamicPrintf(String sourceHandle, IResource resource, int type, int lineNumber, boolean enabled, int ignoreCount, String condition, String printfStr, boolean register) throws CoreException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        CDIDebugModel.setLineBreakpointAttributes(attributes, sourceHandle, type, lineNumber, enabled, ignoreCount, condition);
        attributes.put("org.eclipse.cdt.debug.core.printf_string", printfStr);
        return new CLineDynamicPrintf(resource, attributes, register);
    }

    public static ICLineBreakpoint createBlankLineDynamicPrintf() {
        return new CLineDynamicPrintf();
    }

    public static void setLineBreakpointAttributes(Map<String, Object> attributes, String sourceHandle, Integer type, int lineNumber, boolean enabled, int ignoreCount, String condition) {
        attributes.put("org.eclipse.debug.core.id", CDIDebugModel.getPluginIdentifier());
        attributes.put("lineNumber", lineNumber);
        attributes.put("org.eclipse.debug.core.enabled", enabled);
        attributes.put("org.eclipse.cdt.debug.core.ignoreCount", ignoreCount);
        attributes.put("org.eclipse.cdt.debug.core.condition", condition);
        attributes.put("org.eclipse.cdt.debug.core.sourceHandle", sourceHandle);
        attributes.put("org.eclipse.cdt.debug.core.breakpointType", type);
        if (!attributes.containsKey("requestedSourceHandle")) {
            attributes.put("requestedSourceHandle", sourceHandle);
        }
        if (!attributes.containsKey("requestedLine")) {
            attributes.put("requestedLine", lineNumber);
        }
        if (attributes.containsKey("charStart") && !attributes.containsKey("requestedCharStart")) {
            attributes.put("requestedCharStart", attributes.get("charStart"));
        }
        if (attributes.containsKey("charEnd") && !attributes.containsKey("requestedCharEnd")) {
            attributes.put("requestedCharEnd", attributes.get("charEnd"));
        }
    }

    @Deprecated
    public static ICAddressBreakpoint createAddressBreakpoint(String module, String sourceHandle, IResource resource, IAddress address, boolean enabled, int ignoreCount, String condition, boolean register) throws CoreException {
        return CDIDebugModel.createAddressBreakpoint(module, sourceHandle, resource, 0, -1, address, enabled, ignoreCount, condition, register);
    }

    public static ICAddressBreakpoint createAddressBreakpoint(String module, String sourceHandle, IResource resource, int type, IAddress address, boolean enabled, int ignoreCount, String condition, boolean register) throws CoreException {
        return CDIDebugModel.createAddressBreakpoint(module, sourceHandle, resource, type, -1, address, enabled, ignoreCount, condition, register);
    }

    public static ICAddressBreakpoint createAddressBreakpoint(String module, String sourceHandle, IResource resource, int type, int lineNumber, IAddress address, boolean enabled, int ignoreCount, String condition, boolean register) throws CoreException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        CDIDebugModel.setAddressBreakpointAttributes(attributes, module, sourceHandle, type, lineNumber, address, enabled, ignoreCount, condition);
        return new CAddressBreakpoint(resource, attributes, register);
    }

    public static ICAddressBreakpoint createBlankAddressBreakpoint() {
        return new CAddressBreakpoint();
    }

    public static ICAddressBreakpoint createAddressTracepoint(String module, String sourceHandle, IResource resource, int type, int lineNumber, IAddress address, boolean enabled, int ignoreCount, String condition, boolean register) throws CoreException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        CDIDebugModel.setAddressBreakpointAttributes(attributes, module, sourceHandle, type, lineNumber, address, enabled, ignoreCount, condition);
        return new CAddressTracepoint(resource, attributes, register);
    }

    public static ICAddressBreakpoint createBlankAddressTracepoint() {
        return new CAddressTracepoint();
    }

    public static ICAddressBreakpoint createAddressDynamicPrintf(String module, String sourceHandle, IResource resource, int type, int lineNumber, IAddress address, boolean enabled, int ignoreCount, String condition, String printfStr, boolean register) throws CoreException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        CDIDebugModel.setAddressBreakpointAttributes(attributes, module, sourceHandle, type, lineNumber, address, enabled, ignoreCount, condition);
        attributes.put("org.eclipse.cdt.debug.core.printf_string", printfStr);
        return new CAddressDynamicPrintf(resource, attributes, register);
    }

    public static ICAddressBreakpoint createBlankAddressDynamicPrintf() {
        return new CAddressDynamicPrintf();
    }

    public static void setAddressBreakpointAttributes(Map<String, Object> attributes, String module, String sourceHandle, int type, int lineNumber, IAddress address, boolean enabled, int ignoreCount, String condition) {
        CDIDebugModel.setLineBreakpointAttributes(attributes, sourceHandle, type, lineNumber, enabled, ignoreCount, condition);
        attributes.put("charStart", -1);
        attributes.put("charEnd", -1);
        attributes.put("org.eclipse.cdt.debug.core.address", address.toHexAddressString());
        attributes.put("org.eclipse.cdt.debug.core.module", module);
    }

    public static ICWatchpoint createBlankWatchpoint() {
        return new CWatchpoint();
    }

    public static ICWatchpoint createWatchpoint(String sourceHandle, IResource resource, boolean writeAccess, boolean readAccess, String expression, boolean enabled, int ignoreCount, String condition, boolean register) throws CoreException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        CDIDebugModel.setWatchPointAttributes(attributes, sourceHandle, resource, writeAccess, readAccess, expression, "", BigInteger.ZERO, enabled, ignoreCount, condition);
        return new CWatchpoint(resource, attributes, register);
    }

    public static ICWatchpoint createWatchpoint(String sourceHandle, IResource resource, int type, boolean writeAccess, boolean readAccess, String expression, boolean enabled, int ignoreCount, String condition, boolean register) throws CoreException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        CDIDebugModel.setWatchPointAttributes(attributes, sourceHandle, resource, type, writeAccess, readAccess, expression, "", BigInteger.ZERO, enabled, ignoreCount, condition);
        return new CWatchpoint(resource, attributes, register);
    }

    public static ICWatchpoint createWatchpoint(String sourceHandle, IResource resource, int charStart, int charEnd, int lineNumber, boolean writeAccess, boolean readAccess, String expression, String memorySpace, BigInteger range, boolean enabled, int ignoreCount, String condition, boolean register) throws CoreException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        CDIDebugModel.setWatchPointAttributes(attributes, sourceHandle, resource, writeAccess, readAccess, expression, memorySpace, range, enabled, ignoreCount, condition);
        attributes.put("charStart", charStart);
        attributes.put("charEnd", charEnd);
        attributes.put("lineNumber", lineNumber);
        return new CWatchpoint(resource, attributes, register);
    }

    public static ICWatchpoint createWatchpoint(String sourceHandle, IResource resource, boolean writeAccess, boolean readAccess, String expression, String memorySpace, BigInteger range, boolean enabled, int ignoreCount, String condition, boolean register) throws CoreException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        CDIDebugModel.setWatchPointAttributes(attributes, sourceHandle, resource, writeAccess, readAccess, expression, memorySpace, range, enabled, ignoreCount, condition);
        return new CWatchpoint(resource, attributes, register);
    }

    public static void setWatchPointAttributes(Map<String, Object> attributes, String sourceHandle, IResource resource, boolean writeAccess, boolean readAccess, String expression, String memorySpace, BigInteger range, boolean enabled, int ignoreCount, String condition) {
        attributes.put("org.eclipse.debug.core.id", CDIDebugModel.getPluginIdentifier());
        attributes.put("org.eclipse.debug.core.enabled", enabled);
        attributes.put("org.eclipse.cdt.debug.core.ignoreCount", ignoreCount);
        attributes.put("org.eclipse.cdt.debug.core.condition", condition);
        attributes.put("org.eclipse.cdt.debug.core.sourceHandle", sourceHandle);
        attributes.put("org.eclipse.cdt.debug.core.expression", expression);
        attributes.put("org.eclipse.cdt.debug.core.memoryspace", memorySpace);
        attributes.put("org.eclipse.cdt.debug.core.range", range.toString());
        attributes.put("org.eclipse.cdt.debug.core.read", readAccess);
        attributes.put("org.eclipse.cdt.debug.core.write", writeAccess);
    }

    public static void setWatchPointAttributes(Map<String, Object> attributes, String sourceHandle, IResource resource, int type, boolean writeAccess, boolean readAccess, String expression, String memorySpace, BigInteger range, boolean enabled, int ignoreCount, String condition) {
        CDIDebugModel.setWatchPointAttributes(attributes, sourceHandle, resource, writeAccess, readAccess, expression, memorySpace, range, enabled, ignoreCount, condition);
        attributes.put("org.eclipse.cdt.debug.core.breakpointType", type);
    }

    @Deprecated
    public static ICFunctionBreakpoint createFunctionBreakpoint(String sourceHandle, IResource resource, String function, int charStart, int charEnd, int lineNumber, boolean enabled, int ignoreCount, String condition, boolean register) throws CoreException {
        return CDIDebugModel.createFunctionBreakpoint(sourceHandle, resource, 0, function, charStart, charEnd, lineNumber, enabled, ignoreCount, condition, register);
    }

    public static ICFunctionBreakpoint createFunctionBreakpoint(String sourceHandle, IResource resource, int type, String function, int charStart, int charEnd, int lineNumber, boolean enabled, int ignoreCount, String condition, boolean register) throws CoreException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        CDIDebugModel.setFunctionBreakpointAttributes(attributes, sourceHandle, type, function, charStart, charEnd, lineNumber, enabled, ignoreCount, condition);
        return new CFunctionBreakpoint(resource, attributes, register);
    }

    public static ICFunctionBreakpoint createBlankFunctionBreakpoint() {
        return new CFunctionBreakpoint();
    }

    public static ICFunctionBreakpoint createFunctionTracepoint(String sourceHandle, IResource resource, int type, String function, int charStart, int charEnd, int lineNumber, boolean enabled, int ignoreCount, String condition, boolean register) throws CoreException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        CDIDebugModel.setFunctionBreakpointAttributes(attributes, sourceHandle, type, function, charStart, charEnd, lineNumber, enabled, ignoreCount, condition);
        return new CFunctionTracepoint(resource, attributes, register);
    }

    public static ICFunctionBreakpoint createBlankFunctionTracepoint() {
        return new CFunctionTracepoint();
    }

    public static ICFunctionBreakpoint createFunctionDynamicPrintf(String sourceHandle, IResource resource, int type, String function, int charStart, int charEnd, int lineNumber, boolean enabled, int ignoreCount, String condition, String printfStr, boolean register) throws CoreException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
        CDIDebugModel.setFunctionBreakpointAttributes(attributes, sourceHandle, type, function, charStart, charEnd, lineNumber, enabled, ignoreCount, condition);
        attributes.put("org.eclipse.cdt.debug.core.printf_string", printfStr);
        return new CFunctionDynamicPrintf(resource, attributes, register);
    }

    public static ICFunctionBreakpoint createBlankFunctionDynamicPrintf() {
        return new CFunctionDynamicPrintf();
    }

    public static void setFunctionBreakpointAttributes(Map<String, Object> attributes, String sourceHandle, int type, String function, int charStart, int charEnd, int lineNumber, boolean enabled, int ignoreCount, String condition) {
        CDIDebugModel.setLineBreakpointAttributes(attributes, sourceHandle, type, lineNumber, enabled, ignoreCount, condition);
        attributes.put("charStart", charStart);
        attributes.put("charEnd", charEnd);
        attributes.put("org.eclipse.cdt.debug.core.function", function);
    }

    public static ICLineBreakpoint lineBreakpointExists(String sourceHandle, IResource resource, int lineNumber) throws CoreException {
        String modelId = CDIDebugModel.getPluginIdentifier();
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = manager.getBreakpoints(modelId);
        int i = 0;
        while (i < breakpoints.length) {
            ICLineBreakpoint breakpoint;
            if (breakpoints[i] instanceof ICLineBreakpoint && CDIDebugModel.sameSourceHandle(sourceHandle, (breakpoint = (ICLineBreakpoint)breakpoints[i]).getSourceHandle()) && breakpoint.getLineNumber() == lineNumber) {
                return breakpoint;
            }
            ++i;
        }
        return null;
    }

    public static ICWatchpoint watchpointExists(String sourceHandle, IResource resource, String expression) throws CoreException {
        String modelId = CDIDebugModel.getPluginIdentifier();
        String markerType = "org.eclipse.cdt.debug.core.cWatchpointMarker";
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = manager.getBreakpoints(modelId);
        int i = 0;
        while (i < breakpoints.length) {
            ICWatchpoint breakpoint;
            if (breakpoints[i] instanceof ICWatchpoint && (breakpoint = (ICWatchpoint)breakpoints[i]).getMarker().getType().equals(markerType) && CDIDebugModel.sameSourceHandle(sourceHandle, breakpoint.getSourceHandle()) && breakpoint.getMarker().getResource().equals((Object)resource) && breakpoint.getExpression().equals(expression)) {
                return breakpoint;
            }
            ++i;
        }
        return null;
    }

    public static ICFunctionBreakpoint functionBreakpointExists(String sourceHandle, IResource resource, String function) throws CoreException {
        String modelId = CDIDebugModel.getPluginIdentifier();
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = manager.getBreakpoints(modelId);
        int i = 0;
        while (i < breakpoints.length) {
            ICFunctionBreakpoint breakpoint;
            if (breakpoints[i] instanceof ICFunctionBreakpoint && CDIDebugModel.sameSourceHandle(sourceHandle, (breakpoint = (ICFunctionBreakpoint)breakpoints[i]).getSourceHandle()) && breakpoint.getMarker().getResource().equals((Object)resource) && breakpoint.getFunction() != null && breakpoint.getFunction().equals(function)) {
                return breakpoint;
            }
            ++i;
        }
        return null;
    }

    private static boolean sameSourceHandle(String handle1, String handle2) {
        if (handle1 == null || handle2 == null) {
            return false;
        }
        Path path1 = new Path(handle1);
        Path path2 = new Path(handle2);
        if (path1.isValidPath(handle1) && path2.isValidPath(handle2)) {
            return path1.equals((Object)path2);
        }
        return handle1.equals(handle2);
    }

    public static ICEventBreakpoint eventBreakpointExists(String type, String arg) throws CoreException {
        String modelId = CDIDebugModel.getPluginIdentifier();
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = manager.getBreakpoints(modelId);
        int i = 0;
        while (i < breakpoints.length) {
            ICEventBreakpoint breakpoint;
            if (breakpoints[i] instanceof ICEventBreakpoint && (breakpoint = (ICEventBreakpoint)breakpoints[i]).getEventType().equals(type)) {
                String arg2;
                String arg1 = breakpoint.getEventArgument();
                if (arg1 == null) {
                    arg1 = "";
                }
                String string = arg2 = arg == null ? "" : arg;
                if (arg1.equals(arg2)) {
                    return breakpoint;
                }
            }
            ++i;
        }
        return null;
    }

    public static ICEventBreakpoint createEventBreakpoint(String type, String arg, boolean register) throws CoreException {
        IWorkspaceRoot resource = ResourcesPlugin.getWorkspace().getRoot();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        CDIDebugModel.setEventBreakpointAttributes(attributes, type, arg);
        return new CEventBreakpoint((IResource)resource, attributes, register);
    }

    public static void setEventBreakpointAttributes(Map<String, Object> attributes, String type, String arg) {
        attributes.put("org.eclipse.debug.core.id", CDIDebugModel.getPluginIdentifier());
        attributes.put("org.eclipse.debug.core.enabled", true);
        attributes.put("org.eclipse.cdt.debug.core.ignoreCount", 0);
        attributes.put("org.eclipse.cdt.debug.core.condition", "");
        attributes.put("org.eclipse.cdt.debug.core.eventbreakpoint_event_id", type);
        attributes.put("org.eclipse.cdt.debug.core.eventbreakpoint_event_arg", arg);
    }

    public static ICEventBreakpoint createBlankEventBreakpoint() {
        return new CEventBreakpoint();
    }

    public static void createBreakpointMarker(final ICBreakpoint breakpoint, final IResource resource, final Map<String, Object> attributes, final boolean add) throws CoreException {
        if (breakpoint.getMarker() != null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.debug.core", "Cannot create breakpoint marker breakpoint given breakpoint already has an assotiated maker"));
        }
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = resource.createMarker(CDIDebugModel.calculateMarkerType(breakpoint));
                breakpoint.setMarker(marker);
                marker.setAttributes(attributes);
                if (breakpoint instanceof ICBreakpoint2) {
                    ((ICBreakpoint2)breakpoint).refreshMessage();
                }
                if (add) {
                    DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)breakpoint);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(wr, null);
    }
}

