/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.concurrent;

import java.util.HashSet;
import org.eclipse.cdt.dsf.concurrent.DefaultDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.StackTraceWrapper;
import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.cdt.dsf.internal.DsfPlugin;
import org.eclipse.core.runtime.Platform;

@ThreadSafe
public class DsfExecutable {
    static boolean DEBUG_EXECUTOR = false;
    static boolean DEBUG_MONITORS = false;
    static boolean ASSERTIONS_ENABLED = false;
    final StackTraceWrapper fCreatedAt;
    final DefaultDsfExecutor.TracingWrapper fCreatedBy;
    private volatile boolean fSubmitted = false;

    static {
        if (!$assertionsDisabled) {
            ASSERTIONS_ENABLED = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        DEBUG_EXECUTOR = DsfPlugin.DEBUG && Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.cdt.dsf/debug/executor"));
        DEBUG_MONITORS = DsfPlugin.DEBUG && Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.cdt.dsf/debug/monitors"));
    }

    public DsfExecutable() {
        if (ASSERTIONS_ENABLED || DEBUG_EXECUTOR || DEBUG_MONITORS) {
            DefaultDsfExecutor executor = DefaultDsfExecutor.fThreadToExecutorMap.get(Thread.currentThread());
            this.fCreatedBy = executor != null ? executor.fCurrentlyExecuting : null;
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            Class<?> thisClass = this.getClass();
            HashSet<String> classNamesSet = new HashSet<String>();
            while (thisClass != null) {
                classNamesSet.add(thisClass.getName());
                thisClass = thisClass.getSuperclass();
            }
            int i = 3;
            while (i < stackTrace.length) {
                if (!classNamesSet.contains(stackTrace[i].getClassName())) break;
                ++i;
            }
            this.fCreatedAt = new StackTraceWrapper(new StackTraceElement[stackTrace.length - i]);
            System.arraycopy(stackTrace, i, this.fCreatedAt.fStackTraceElements, 0, this.fCreatedAt.fStackTraceElements.length);
        } else {
            this.fCreatedAt = null;
            this.fCreatedBy = null;
        }
    }

    public boolean getSubmitted() {
        return this.fSubmitted;
    }

    public void setSubmitted() {
        this.fSubmitted = true;
    }

    protected boolean isExecutionRequired() {
        return true;
    }
}

