/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jenkins.ui;

import java.net.URISyntaxException;
import java.util.List;
import java.util.UUID;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.discovery.IDiscoveryLocator;
import org.eclipse.ecf.discovery.IServiceEvent;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.discovery.IServiceListener;
import org.eclipse.ecf.discovery.IServiceProperties;
import org.eclipse.ecf.discovery.identity.IServiceID;
import org.eclipse.ecf.discovery.identity.IServiceTypeID;
import org.eclipse.mylyn.builds.ui.BuildsUi;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.repositories.core.RepositoryLocation;
import org.eclipse.mylyn.internal.jenkins.ui.Messages;
import org.eclipse.osgi.util.NLS;

public class JenkinsDiscovery {
    private static final String ECF_DISCOVERY_JMDNS = "ecf.discovery.jmdns";
    private static final String JENKINS_MDNS_ID = "_jenkins._tcp.local._iana";
    private static final String URL_PROPERTY = "url";
    private static final String SERVER_ID_PROPERTY = "server-id";
    private IContainer container;

    protected IContainer getContainer() throws ContainerCreateException {
        return ContainerFactory.getDefault().createContainer(ECF_DISCOVERY_JMDNS);
    }

    private boolean isNew(String url, String id) {
        if (url == null) {
            return false;
        }
        List locations = BuildsUi.getServerLocations();
        for (RepositoryLocation location : locations) {
            if (!location.hasUrl(url) && !location.getId().equals(id)) continue;
            return false;
        }
        return true;
    }

    public void start() {
        try {
            this.container = this.getContainer();
            IDiscoveryLocator adapter = (IDiscoveryLocator)this.container.getAdapter(IDiscoveryLocator.class);
            adapter.addServiceListener((IServiceListener)new JenkinsServiceListener());
            this.container.connect(null, null);
        }
        catch (ContainerConnectException | ContainerCreateException e) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.hudson.ui", Messages.Discovery_CouldNotStartService, e));
        }
    }

    public void stop() {
        if (this.container != null) {
            this.container.disconnect();
            this.container = null;
        }
    }

    private void notifyMessage(String title, String description) {
        BuildsUi.serverDiscovered((String)title, (String)description);
    }

    private void issueJenkinsNotification(IServiceProperties properties) throws URISyntaxException {
        String id;
        String url = properties.getProperty(URL_PROPERTY).toString();
        if (this.isNew(url, id = this.getId(properties))) {
            this.notifyMessage(Messages.JenkinsDiscovery_MessageTitle, NLS.bind((String)Messages.JenkinsDiscovery_MessageText, (Object[])new String[]{url, Messages.JenkinsDiscovery_ServerName, url, id}));
        }
    }

    private String getId(IServiceProperties properties) {
        String id = (String)properties.getProperty(SERVER_ID_PROPERTY);
        if (id == null) {
            id = UUID.randomUUID().toString();
        }
        return id;
    }

    private static abstract class AbstractServiceListener {
        private AbstractServiceListener() {
        }

        public abstract boolean triggerDiscovery();
    }

    private final class JenkinsServiceListener
    extends AbstractServiceListener
    implements IServiceListener {
        private JenkinsServiceListener() {
        }

        public void serviceDiscovered(IServiceEvent anEvent) {
            IServiceInfo serviceInfo = anEvent.getServiceInfo();
            IServiceID serviceId = serviceInfo.getServiceID();
            IServiceTypeID serviceTypeId = serviceId.getServiceTypeID();
            if (serviceTypeId.getName().equals(JenkinsDiscovery.JENKINS_MDNS_ID)) {
                IServiceProperties properties = serviceInfo.getServiceProperties();
                try {
                    if (properties.getProperty(JenkinsDiscovery.URL_PROPERTY) == null) {
                        JenkinsDiscovery.this.notifyMessage(Messages.JenkinsDiscovery_MessageTitle, NLS.bind((String)Messages.JenkinsDiscovery_MissingURL, (Object[])new Object[]{serviceInfo.getLocation().getHost()}));
                    } else {
                        JenkinsDiscovery.this.issueJenkinsNotification(properties);
                    }
                }
                catch (URISyntaxException e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.hudson.ui", NLS.bind((String)Messages.Discovery_IncorrectURI, (Object[])new Object[]{properties.getProperty(JenkinsDiscovery.URL_PROPERTY).toString()}), (Throwable)e));
                }
            }
        }

        public void serviceUndiscovered(IServiceEvent anEvent) {
        }

        @Override
        public boolean triggerDiscovery() {
            return false;
        }
    }
}

