/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.cdt.ui.contentassist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.ui.text.ICCompletionProposal;
import org.eclipse.cdt.ui.text.contentassist.ICompletionProposalComputer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.cdt.ui.contentassist.CCompletionProposal;

public class FocusedCProposalProcessor {
    private static final int THRESHOLD_INTEREST = 10000;
    private static final int THRESHOLD_IMPLICIT_INTEREST = 20000;
    private static final int RELEVANCE_IMPLICIT_INTEREST_C = 600;
    private static final int RELEVANCE_IMPLICIT_INTEREST_MISC = 110;
    private static final String IDENTIFIER_THIS = "this";
    public static final String LABEL_SEPARATOR = " -------------------------------------------- ";
    public static final FocusedProposalSeparator PROPOSAL_SEPARATOR = new FocusedProposalSeparator();
    private final List<ICompletionProposalComputer> monitoredProposalComputers = new ArrayList<ICompletionProposalComputer>();
    private final List<ICompletionProposalComputer> alreadyComputedProposals = new ArrayList<ICompletionProposalComputer>();
    private final List<ICompletionProposalComputer> alreadyContainSeparator = new ArrayList<ICompletionProposalComputer>();
    private final List<ICompletionProposalComputer> containsSingleInterestingProposal = new ArrayList<ICompletionProposalComputer>();
    private static FocusedCProposalProcessor INSTANCE = new FocusedCProposalProcessor();

    private FocusedCProposalProcessor() {
    }

    public static FocusedCProposalProcessor getDefault() {
        return INSTANCE;
    }

    public void addMonitoredComputer(ICompletionProposalComputer proposalComputer) {
        this.monitoredProposalComputers.add(proposalComputer);
    }

    public List projectInterestModel(ICompletionProposalComputer proposalComputer, List proposals) {
        try {
            if (!ContextCore.getContextManager().isContextActive()) {
                return proposals;
            }
            boolean hasInterestingProposals = false;
            for (Object object : proposals) {
                if (!(object instanceof CCompletionProposal)) continue;
                boolean foundInteresting = this.boostRelevanceWithInterest((CCompletionProposal)((Object)object));
                if (hasInterestingProposals || !foundInteresting) continue;
                hasInterestingProposals = true;
            }
            if (this.containsSingleInterestingProposal.size() > 0 && proposals.size() > 0) {
                proposals.add(PROPOSAL_SEPARATOR);
            } else if (hasInterestingProposals) {
                if (proposals.size() == 1) {
                    this.containsSingleInterestingProposal.add(proposalComputer);
                } else {
                    proposals.add(PROPOSAL_SEPARATOR);
                    this.alreadyContainSeparator.add(proposalComputer);
                }
            }
            this.alreadyComputedProposals.add(proposalComputer);
            if (this.alreadyComputedProposals.size() == this.monitoredProposalComputers.size()) {
                this.alreadyComputedProposals.clear();
                this.alreadyContainSeparator.clear();
                this.containsSingleInterestingProposal.clear();
            }
            return proposals;
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.cdt.mylyn.ui", "Failed to project interest onto propsals", t));
            return proposals;
        }
    }

    private boolean boostRelevanceWithInterest(CCompletionProposal proposal) {
        boolean hasInteresting = false;
        String name = proposal.getBindingName();
        if (name != null) {
            IInteractionElement interactionElement = this.guessInteractionElement(name);
            if (interactionElement != null) {
                float interest = interactionElement.getInterest().getValue();
                if (interest > ContextCore.getCommonContextScaling().getInteresting()) {
                    proposal.setRelevance(10000 + (int)(interest * 10.0f));
                    hasInteresting = true;
                } else if (proposal.getRelevance() > 600) {
                    proposal.setRelevance(20000 + proposal.getRelevance());
                }
            } else if (proposal.getRelevance() > 600) {
                proposal.setRelevance(20000 + proposal.getRelevance());
            }
        } else if (this.isImplicitlyInteresting((ICCompletionProposal)proposal)) {
            proposal.setRelevance(20000 + proposal.getRelevance());
            hasInteresting = true;
        }
        return hasInteresting;
    }

    private IInteractionElement guessInteractionElement(String name) {
        for (IInteractionElement element : ContextCore.getContextManager().getActiveContext().getInteresting()) {
            String handle = element.getHandleIdentifier();
            if (handle.contains("#")) {
                handle = handle.substring(0, handle.indexOf("#"));
            }
            if (!handle.endsWith(name)) continue;
            return element;
        }
        return null;
    }

    public boolean isImplicitlyInteresting(ICCompletionProposal proposal) {
        return proposal.getRelevance() > 110 && !IDENTIFIER_THIS.equals(proposal.getDisplayString());
    }

    static class FocusedProposalSeparator
    extends CCompletionProposal {
        public FocusedProposalSeparator() {
            super("", 0, 0, CommonImages.getImage((ImageDescriptor)CommonImages.SEPARATOR_LIST), FocusedCProposalProcessor.LABEL_SEPARATOR, "", 10000, null, null, null);
        }

        public void apply(IDocument document) {
        }

        public void apply(IDocument document, char trigger, int offset) {
        }

        public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        }
    }
}

