/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.EndpointSpec;
import org.mandas.docker.client.messages.swarm.NetworkAttachmentConfig;
import org.mandas.docker.client.messages.swarm.ServiceMode;
import org.mandas.docker.client.messages.swarm.ServiceSpec;
import org.mandas.docker.client.messages.swarm.TaskSpec;
import org.mandas.docker.client.messages.swarm.UpdateConfig;

final class ImmutableServiceSpec
implements ServiceSpec {
    @Nullable
    private final String name;
    @Nullable
    private final Map<String, String> labels;
    private final TaskSpec taskTemplate;
    @Nullable
    private final ServiceMode mode;
    @Nullable
    private final UpdateConfig updateConfig;
    @Nullable
    private final List<NetworkAttachmentConfig> networks;
    @Nullable
    private final EndpointSpec endpointSpec;

    private ImmutableServiceSpec(@Nullable String name, @Nullable Map<String, String> labels, TaskSpec taskTemplate, @Nullable ServiceMode mode, @Nullable UpdateConfig updateConfig, @Nullable List<NetworkAttachmentConfig> networks, @Nullable EndpointSpec endpointSpec) {
        this.name = name;
        this.labels = labels;
        this.taskTemplate = taskTemplate;
        this.mode = mode;
        this.updateConfig = updateConfig;
        this.networks = networks;
        this.endpointSpec = endpointSpec;
    }

    @Override
    @JsonProperty(value="Name")
    @Nullable
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="Labels")
    @Nullable
    public Map<String, String> labels() {
        return this.labels;
    }

    @Override
    @JsonProperty(value="TaskTemplate")
    public TaskSpec taskTemplate() {
        return this.taskTemplate;
    }

    @Override
    @JsonProperty(value="Mode")
    @Nullable
    public ServiceMode mode() {
        return this.mode;
    }

    @Override
    @JsonProperty(value="UpdateConfig")
    @Nullable
    public UpdateConfig updateConfig() {
        return this.updateConfig;
    }

    @Override
    @JsonProperty(value="Networks")
    @Deprecated
    @Nullable
    public List<NetworkAttachmentConfig> networks() {
        return this.networks;
    }

    @Override
    @JsonProperty(value="EndpointSpec")
    @Nullable
    public EndpointSpec endpointSpec() {
        return this.endpointSpec;
    }

    public final ImmutableServiceSpec withName(@Nullable String value) {
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new ImmutableServiceSpec(value, this.labels, this.taskTemplate, this.mode, this.updateConfig, this.networks, this.endpointSpec);
    }

    public final ImmutableServiceSpec withLabels(@Nullable Map<String, ? extends String> entries) {
        if (this.labels == entries) {
            return this;
        }
        Map<String, String> newValue = entries == null ? null : ImmutableServiceSpec.createUnmodifiableMap(true, false, entries);
        return new ImmutableServiceSpec(this.name, newValue, this.taskTemplate, this.mode, this.updateConfig, this.networks, this.endpointSpec);
    }

    public final ImmutableServiceSpec withTaskTemplate(TaskSpec value) {
        if (this.taskTemplate == value) {
            return this;
        }
        TaskSpec newValue = Objects.requireNonNull(value, "taskTemplate");
        return new ImmutableServiceSpec(this.name, this.labels, newValue, this.mode, this.updateConfig, this.networks, this.endpointSpec);
    }

    public final ImmutableServiceSpec withMode(@Nullable ServiceMode value) {
        if (this.mode == value) {
            return this;
        }
        return new ImmutableServiceSpec(this.name, this.labels, this.taskTemplate, value, this.updateConfig, this.networks, this.endpointSpec);
    }

    public final ImmutableServiceSpec withUpdateConfig(@Nullable UpdateConfig value) {
        if (this.updateConfig == value) {
            return this;
        }
        return new ImmutableServiceSpec(this.name, this.labels, this.taskTemplate, this.mode, value, this.networks, this.endpointSpec);
    }

    @Deprecated
    public final ImmutableServiceSpec withNetworks(NetworkAttachmentConfig ... elements) {
        if (elements == null) {
            if (this.networks == null) {
                return this;
            }
            return new ImmutableServiceSpec(this.name, this.labels, this.taskTemplate, this.mode, this.updateConfig, null, this.endpointSpec);
        }
        List<NetworkAttachmentConfig> newValue = ImmutableServiceSpec.createUnmodifiableList(false, ImmutableServiceSpec.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableServiceSpec(this.name, this.labels, this.taskTemplate, this.mode, this.updateConfig, newValue, this.endpointSpec);
    }

    @Deprecated
    public final ImmutableServiceSpec withNetworks(@Nullable Iterable<? extends NetworkAttachmentConfig> elements) {
        if (this.networks == elements) {
            return this;
        }
        List<NetworkAttachmentConfig> newValue = elements == null ? null : ImmutableServiceSpec.createUnmodifiableList(false, ImmutableServiceSpec.createSafeList(elements, true, false));
        return new ImmutableServiceSpec(this.name, this.labels, this.taskTemplate, this.mode, this.updateConfig, newValue, this.endpointSpec);
    }

    public final ImmutableServiceSpec withEndpointSpec(@Nullable EndpointSpec value) {
        if (this.endpointSpec == value) {
            return this;
        }
        return new ImmutableServiceSpec(this.name, this.labels, this.taskTemplate, this.mode, this.updateConfig, this.networks, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableServiceSpec && this.equalsByValue((ImmutableServiceSpec)another);
    }

    private boolean equalsByValue(ImmutableServiceSpec another) {
        return Objects.equals(this.name, another.name) && Objects.equals(this.labels, another.labels) && this.taskTemplate.equals(another.taskTemplate) && Objects.equals(this.mode, another.mode) && Objects.equals(this.updateConfig, another.updateConfig) && Objects.equals(this.networks, another.networks) && Objects.equals(this.endpointSpec, another.endpointSpec);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.labels);
        h += (h << 5) + this.taskTemplate.hashCode();
        h += (h << 5) + Objects.hashCode(this.mode);
        h += (h << 5) + Objects.hashCode(this.updateConfig);
        h += (h << 5) + Objects.hashCode(this.networks);
        h += (h << 5) + Objects.hashCode(this.endpointSpec);
        return h;
    }

    public String toString() {
        return "ServiceSpec{name=" + this.name + ", labels=" + String.valueOf(this.labels) + ", taskTemplate=" + String.valueOf(this.taskTemplate) + ", mode=" + String.valueOf(this.mode) + ", updateConfig=" + String.valueOf(this.updateConfig) + ", networks=" + String.valueOf(this.networks) + ", endpointSpec=" + String.valueOf(this.endpointSpec) + "}";
    }

    public static ImmutableServiceSpec copyOf(ServiceSpec instance) {
        if (instance instanceof ImmutableServiceSpec) {
            return (ImmutableServiceSpec)instance;
        }
        return ImmutableServiceSpec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    static final class Builder
    implements ServiceSpec.Builder {
        private static final long INIT_BIT_TASK_TEMPLATE = 1L;
        private long initBits = 1L;
        private String name;
        private Map<String, String> labels = null;
        private TaskSpec taskTemplate;
        private ServiceMode mode;
        private UpdateConfig updateConfig;
        private List<NetworkAttachmentConfig> networks = null;
        private EndpointSpec endpointSpec;

        private Builder() {
        }

        public final Builder from(ServiceSpec instance) {
            EndpointSpec endpointSpecValue;
            List<NetworkAttachmentConfig> networksValue;
            UpdateConfig updateConfigValue;
            Map<String, String> labelsValue;
            Objects.requireNonNull(instance, "instance");
            String nameValue = instance.name();
            if (nameValue != null) {
                this.name(nameValue);
            }
            if ((labelsValue = instance.labels()) != null) {
                this.putAllLabels(labelsValue);
            }
            this.taskTemplate(instance.taskTemplate());
            ServiceMode modeValue = instance.mode();
            if (modeValue != null) {
                this.mode(modeValue);
            }
            if ((updateConfigValue = instance.updateConfig()) != null) {
                this.updateConfig(updateConfigValue);
            }
            if ((networksValue = instance.networks()) != null) {
                this.addAllNetworks(networksValue);
            }
            if ((endpointSpecValue = instance.endpointSpec()) != null) {
                this.endpointSpec(endpointSpecValue);
            }
            return this;
        }

        @Override
        @JsonProperty(value="Name")
        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder addLabel(String key, String value) {
            if (this.labels == null) {
                this.labels = new LinkedHashMap<String, String>();
            }
            this.labels.put(Objects.requireNonNull(key, "labels key"), Objects.requireNonNull(value, value == null ? "labels value for key: " + key : null));
            return this;
        }

        public final Builder addLabel(Map.Entry<String, ? extends String> entry) {
            String v;
            if (this.labels == null) {
                this.labels = new LinkedHashMap<String, String>();
            }
            String k = entry.getKey();
            this.labels.put(Objects.requireNonNull(k, "labels key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "labels value for key: " + k : null));
            return this;
        }

        @Override
        @JsonProperty(value="Labels")
        public final Builder labels(@Nullable Map<String, ? extends String> entries) {
            if (entries == null) {
                this.labels = null;
                return this;
            }
            this.labels = new LinkedHashMap<String, String>();
            return this.putAllLabels(entries);
        }

        public final Builder putAllLabels(Map<String, ? extends String> entries) {
            if (this.labels == null) {
                this.labels = new LinkedHashMap<String, String>();
            }
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.labels.put(Objects.requireNonNull(k, "labels key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "labels value for key: " + k : null));
            }
            return this;
        }

        @Override
        @JsonProperty(value="TaskTemplate")
        public final Builder taskTemplate(TaskSpec taskTemplate) {
            this.taskTemplate = Objects.requireNonNull(taskTemplate, "taskTemplate");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @JsonProperty(value="Mode")
        public final Builder mode(@Nullable ServiceMode mode) {
            this.mode = mode;
            return this;
        }

        @Override
        @JsonProperty(value="UpdateConfig")
        public final Builder updateConfig(@Nullable UpdateConfig updateConfig) {
            this.updateConfig = updateConfig;
            return this;
        }

        @Deprecated
        public final Builder network(NetworkAttachmentConfig element) {
            if (this.networks == null) {
                this.networks = new ArrayList<NetworkAttachmentConfig>();
            }
            this.networks.add(Objects.requireNonNull(element, "networks element"));
            return this;
        }

        @Override
        @Deprecated
        public final Builder networks(NetworkAttachmentConfig ... elements) {
            if (this.networks == null) {
                this.networks = new ArrayList<NetworkAttachmentConfig>();
            }
            for (NetworkAttachmentConfig element : elements) {
                this.networks.add(Objects.requireNonNull(element, "networks element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="Networks")
        @Deprecated
        public final Builder networks(@Nullable Iterable<? extends NetworkAttachmentConfig> elements) {
            if (elements == null) {
                this.networks = null;
                return this;
            }
            this.networks = new ArrayList<NetworkAttachmentConfig>();
            return this.addAllNetworks(elements);
        }

        @Deprecated
        public final Builder addAllNetworks(Iterable<? extends NetworkAttachmentConfig> elements) {
            Objects.requireNonNull(elements, "networks element");
            if (this.networks == null) {
                this.networks = new ArrayList<NetworkAttachmentConfig>();
            }
            for (NetworkAttachmentConfig networkAttachmentConfig : elements) {
                this.networks.add(Objects.requireNonNull(networkAttachmentConfig, "networks element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="EndpointSpec")
        public final Builder endpointSpec(@Nullable EndpointSpec endpointSpec) {
            this.endpointSpec = endpointSpec;
            return this;
        }

        @Override
        public ImmutableServiceSpec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableServiceSpec(this.name, this.labels == null ? null : ImmutableServiceSpec.createUnmodifiableMap(false, false, this.labels), this.taskTemplate, this.mode, this.updateConfig, this.networks == null ? null : ImmutableServiceSpec.createUnmodifiableList(true, this.networks), this.endpointSpec);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("taskTemplate");
            }
            return "Cannot build ServiceSpec, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

