/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.mount;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.mount.BindOptions;
import org.mandas.docker.client.messages.mount.Mount;
import org.mandas.docker.client.messages.mount.TmpfsOptions;
import org.mandas.docker.client.messages.mount.VolumeOptions;

final class ImmutableMount
implements Mount {
    @Nullable
    private final String type;
    @Nullable
    private final String source;
    @Nullable
    private final String target;
    @Nullable
    private final Boolean readOnly;
    @Nullable
    private final BindOptions bindOptions;
    @Nullable
    private final VolumeOptions volumeOptions;
    @Nullable
    private final TmpfsOptions tmpfsOptions;

    private ImmutableMount(@Nullable String type, @Nullable String source, @Nullable String target, @Nullable Boolean readOnly, @Nullable BindOptions bindOptions, @Nullable VolumeOptions volumeOptions, @Nullable TmpfsOptions tmpfsOptions) {
        this.type = type;
        this.source = source;
        this.target = target;
        this.readOnly = readOnly;
        this.bindOptions = bindOptions;
        this.volumeOptions = volumeOptions;
        this.tmpfsOptions = tmpfsOptions;
    }

    @Override
    @JsonProperty(value="Type")
    @Nullable
    public String type() {
        return this.type;
    }

    @Override
    @JsonProperty(value="Source")
    @Nullable
    public String source() {
        return this.source;
    }

    @Override
    @JsonProperty(value="Target")
    @Nullable
    public String target() {
        return this.target;
    }

    @Override
    @JsonProperty(value="ReadOnly")
    @Nullable
    public Boolean readOnly() {
        return this.readOnly;
    }

    @Override
    @JsonProperty(value="BindOptions")
    @Nullable
    public BindOptions bindOptions() {
        return this.bindOptions;
    }

    @Override
    @JsonProperty(value="VolumeOptions")
    @Nullable
    public VolumeOptions volumeOptions() {
        return this.volumeOptions;
    }

    @Override
    @JsonProperty(value="TmpfsOptions")
    @Nullable
    public TmpfsOptions tmpfsOptions() {
        return this.tmpfsOptions;
    }

    public final ImmutableMount withType(@Nullable String value) {
        if (Objects.equals(this.type, value)) {
            return this;
        }
        return new ImmutableMount(value, this.source, this.target, this.readOnly, this.bindOptions, this.volumeOptions, this.tmpfsOptions);
    }

    public final ImmutableMount withSource(@Nullable String value) {
        if (Objects.equals(this.source, value)) {
            return this;
        }
        return new ImmutableMount(this.type, value, this.target, this.readOnly, this.bindOptions, this.volumeOptions, this.tmpfsOptions);
    }

    public final ImmutableMount withTarget(@Nullable String value) {
        if (Objects.equals(this.target, value)) {
            return this;
        }
        return new ImmutableMount(this.type, this.source, value, this.readOnly, this.bindOptions, this.volumeOptions, this.tmpfsOptions);
    }

    public final ImmutableMount withReadOnly(@Nullable Boolean value) {
        if (Objects.equals(this.readOnly, value)) {
            return this;
        }
        return new ImmutableMount(this.type, this.source, this.target, value, this.bindOptions, this.volumeOptions, this.tmpfsOptions);
    }

    public final ImmutableMount withBindOptions(@Nullable BindOptions value) {
        if (this.bindOptions == value) {
            return this;
        }
        return new ImmutableMount(this.type, this.source, this.target, this.readOnly, value, this.volumeOptions, this.tmpfsOptions);
    }

    public final ImmutableMount withVolumeOptions(@Nullable VolumeOptions value) {
        if (this.volumeOptions == value) {
            return this;
        }
        return new ImmutableMount(this.type, this.source, this.target, this.readOnly, this.bindOptions, value, this.tmpfsOptions);
    }

    public final ImmutableMount withTmpfsOptions(@Nullable TmpfsOptions value) {
        if (this.tmpfsOptions == value) {
            return this;
        }
        return new ImmutableMount(this.type, this.source, this.target, this.readOnly, this.bindOptions, this.volumeOptions, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMount && this.equalsByValue((ImmutableMount)another);
    }

    private boolean equalsByValue(ImmutableMount another) {
        return Objects.equals(this.type, another.type) && Objects.equals(this.source, another.source) && Objects.equals(this.target, another.target) && Objects.equals(this.readOnly, another.readOnly) && Objects.equals(this.bindOptions, another.bindOptions) && Objects.equals(this.volumeOptions, another.volumeOptions) && Objects.equals(this.tmpfsOptions, another.tmpfsOptions);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.type);
        h += (h << 5) + Objects.hashCode(this.source);
        h += (h << 5) + Objects.hashCode(this.target);
        h += (h << 5) + Objects.hashCode(this.readOnly);
        h += (h << 5) + Objects.hashCode(this.bindOptions);
        h += (h << 5) + Objects.hashCode(this.volumeOptions);
        h += (h << 5) + Objects.hashCode(this.tmpfsOptions);
        return h;
    }

    public String toString() {
        return "Mount{type=" + this.type + ", source=" + this.source + ", target=" + this.target + ", readOnly=" + this.readOnly + ", bindOptions=" + String.valueOf(this.bindOptions) + ", volumeOptions=" + String.valueOf(this.volumeOptions) + ", tmpfsOptions=" + String.valueOf(this.tmpfsOptions) + "}";
    }

    public static ImmutableMount copyOf(Mount instance) {
        if (instance instanceof ImmutableMount) {
            return (ImmutableMount)instance;
        }
        return ImmutableMount.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder
    implements Mount.Builder {
        private String type;
        private String source;
        private String target;
        private Boolean readOnly;
        private BindOptions bindOptions;
        private VolumeOptions volumeOptions;
        private TmpfsOptions tmpfsOptions;

        private Builder() {
        }

        public final Builder from(Mount instance) {
            TmpfsOptions tmpfsOptionsValue;
            VolumeOptions volumeOptionsValue;
            BindOptions bindOptionsValue;
            Boolean readOnlyValue;
            String targetValue;
            String sourceValue;
            Objects.requireNonNull(instance, "instance");
            String typeValue = instance.type();
            if (typeValue != null) {
                this.type(typeValue);
            }
            if ((sourceValue = instance.source()) != null) {
                this.source(sourceValue);
            }
            if ((targetValue = instance.target()) != null) {
                this.target(targetValue);
            }
            if ((readOnlyValue = instance.readOnly()) != null) {
                this.readOnly(readOnlyValue);
            }
            if ((bindOptionsValue = instance.bindOptions()) != null) {
                this.bindOptions(bindOptionsValue);
            }
            if ((volumeOptionsValue = instance.volumeOptions()) != null) {
                this.volumeOptions(volumeOptionsValue);
            }
            if ((tmpfsOptionsValue = instance.tmpfsOptions()) != null) {
                this.tmpfsOptions(tmpfsOptionsValue);
            }
            return this;
        }

        @Override
        @JsonProperty(value="Type")
        public final Builder type(@Nullable String type) {
            this.type = type;
            return this;
        }

        @Override
        @JsonProperty(value="Source")
        public final Builder source(@Nullable String source) {
            this.source = source;
            return this;
        }

        @Override
        @JsonProperty(value="Target")
        public final Builder target(@Nullable String target) {
            this.target = target;
            return this;
        }

        @Override
        @JsonProperty(value="ReadOnly")
        public final Builder readOnly(@Nullable Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        @Override
        @JsonProperty(value="BindOptions")
        public final Builder bindOptions(@Nullable BindOptions bindOptions) {
            this.bindOptions = bindOptions;
            return this;
        }

        @Override
        @JsonProperty(value="VolumeOptions")
        public final Builder volumeOptions(@Nullable VolumeOptions volumeOptions) {
            this.volumeOptions = volumeOptions;
            return this;
        }

        @Override
        @JsonProperty(value="TmpfsOptions")
        public final Builder tmpfsOptions(@Nullable TmpfsOptions tmpfsOptions) {
            this.tmpfsOptions = tmpfsOptions;
            return this;
        }

        @Override
        public ImmutableMount build() {
            return new ImmutableMount(this.type, this.source, this.target, this.readOnly, this.bindOptions, this.volumeOptions, this.tmpfsOptions);
        }
    }
}

