/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.ui.IViewLayout;
import org.eclipse.ui.internal.DirtyPerspectiveMarker;
import org.eclipse.ui.internal.e4.compatibility.ModeledPageLayout;
import org.eclipse.ui.internal.menus.MenuHelper;
import org.eclipse.ui.internal.registry.RegistryReader;

public class PerspectiveExtensionReader
extends RegistryReader {
    private String targetID;
    private ModeledPageLayout pageLayout;
    private Set<String> includeOnlyTags = null;
    private static final String VAL_LEFT = "left";
    private static final String VAL_RIGHT = "right";
    private static final String VAL_TOP = "top";
    private static final String VAL_BOTTOM = "bottom";
    private static final String VAL_STACK = "stack";
    private static final String VAL_FAST = "fast";
    private static final String VAL_TRUE = "true";
    private static final String VAL_FALSE = "false";
    private IExtensionTracker tracker;

    public void extendLayout(IExtensionTracker extensionTracker, String id, ModeledPageLayout out) {
        this.tracker = extensionTracker;
        this.targetID = id;
        this.pageLayout = out;
        this.readRegistry(Platform.getExtensionRegistry(), "org.eclipse.ui", "perspectiveExtensions");
    }

    private boolean includeTag(String tag) {
        return this.includeOnlyTags == null || this.includeOnlyTags.contains(tag);
    }

    private boolean processActionSet(IConfigurationElement element) {
        String id = element.getAttribute("id");
        if (id != null) {
            this.pageLayout.addActionSet(id);
        }
        return true;
    }

    private boolean processExtension(IConfigurationElement element) {
        IConfigurationElement[] children;
        String[] attributes;
        String[] stringArray = attributes = element.getAttributeNames();
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            block48: {
                String attribute = stringArray[n2];
                if (attribute.equals("targetID") || !this.includeTag(attribute)) break block48;
                boolean result = false;
                switch (attribute) {
                    case "editorOnboardingText": {
                        result = this.processEditorOnboardingText(element.getAttribute(attribute));
                        break;
                    }
                    case "editorOnboardingImage": {
                        result = this.processEditorOnboardingImage(element, element.getAttribute(attribute));
                        break;
                    }
                    case "targetID": {
                        result = true;
                        break;
                    }
                }
                if (!result) {
                    ILog.of(this.getClass()).error("Unable to process attribute: " + attribute + " in perspective extension: " + element.getDeclaringExtension().getUniqueIdentifier());
                }
            }
            ++n2;
        }
        IConfigurationElement[] iConfigurationElementArray = children = element.getChildren();
        int n3 = children.length;
        n = 0;
        while (n < n3) {
            block50: {
                IConfigurationElement child = iConfigurationElementArray[n];
                String type = child.getName();
                if (!this.includeTag(type)) break block50;
                boolean result = false;
                switch (type) {
                    case "actionSet": {
                        result = this.processActionSet(child);
                        break;
                    }
                    case "view": {
                        result = this.processView(child);
                        break;
                    }
                    case "viewShortcut": {
                        result = this.processViewShortcut(child);
                        break;
                    }
                    case "newWizardShortcut": {
                        result = this.processWizardShortcut(child);
                        break;
                    }
                    case "perspectiveShortcut": {
                        result = this.processPerspectiveShortcut(child);
                        break;
                    }
                    case "showInPart": {
                        result = this.processShowInPart(child);
                        break;
                    }
                    case "hiddenMenuItem": {
                        result = this.processHiddenMenuItem(child);
                        break;
                    }
                    case "hiddenToolBarItem": {
                        result = this.processHiddenToolBarItem(child);
                        break;
                    }
                    case "editorOnboardingCommand": {
                        result = this.processEditorOnboardingCommand(child);
                        break;
                    }
                }
                if (!result) {
                    ILog.of(this.getClass()).error("Unable to process element: " + type + " in perspective extension: " + element.getDeclaringExtension().getUniqueIdentifier());
                }
            }
            ++n;
        }
        return true;
    }

    private boolean processPerspectiveShortcut(IConfigurationElement element) {
        String id = element.getAttribute("id");
        if (id != null) {
            this.pageLayout.addPerspectiveShortcut(id);
        }
        return true;
    }

    private boolean processShowInPart(IConfigurationElement element) {
        String id = element.getAttribute("id");
        if (id != null) {
            this.pageLayout.addShowInPart(id);
        }
        return true;
    }

    private boolean processHiddenMenuItem(IConfigurationElement element) {
        String id = element.getAttribute("id");
        if (id != null) {
            this.pageLayout.addHiddenMenuItemId(id);
        }
        return true;
    }

    private boolean processHiddenToolBarItem(IConfigurationElement element) {
        String id = element.getAttribute("id");
        if (id != null) {
            this.pageLayout.addHiddenToolBarItemId(id);
        }
        return true;
    }

    private boolean processView(IConfigurationElement element) {
        float ratio;
        boolean minimized;
        String id = element.getAttribute("id");
        String relative = element.getAttribute("relative");
        String relationship = element.getAttribute("relationship");
        String ratioString = element.getAttribute("ratio");
        boolean visible = !VAL_FALSE.equals(element.getAttribute("visible"));
        String closeable = element.getAttribute("closeable");
        String moveable = element.getAttribute("moveable");
        String standalone = element.getAttribute("standalone");
        String showTitle = element.getAttribute("showTitle");
        String minVal = element.getAttribute("minimized");
        boolean bl = minimized = minVal != null && VAL_TRUE.equals(minVal);
        if (id == null) {
            PerspectiveExtensionReader.logMissingAttribute(element, "id");
            return false;
        }
        if (relationship == null) {
            PerspectiveExtensionReader.logMissingAttribute(element, "relationship");
            return false;
        }
        if (!VAL_FAST.equals(relationship) && relative == null) {
            PerspectiveExtensionReader.logError(element, "Attribute 'relative' not defined.  This attribute is required when relationship=\"" + relationship + "\".");
            return false;
        }
        if (ratioString == null) {
            ratio = -2.0f;
        } else {
            try {
                ratio = Float.parseFloat(ratioString);
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (ratio < 0.05f || ratio > 0.95f) {
                ratio = -1.0f;
            }
        }
        boolean stack = false;
        int intRelation = 0;
        boolean fast = false;
        switch (relationship) {
            case "left": {
                intRelation = 1;
                break;
            }
            case "right": {
                intRelation = 2;
                break;
            }
            case "top": {
                intRelation = 3;
                break;
            }
            case "bottom": {
                intRelation = 4;
                break;
            }
            case "stack": {
                stack = true;
                break;
            }
            case "fast": {
                fast = true;
                break;
            }
            default: {
                return false;
            }
        }
        if (visible) {
            this.pageLayout.removePlaceholder(id);
        }
        if (stack) {
            if (visible) {
                this.pageLayout.stackView(id, relative, true);
            } else {
                this.pageLayout.stackView(id, relative, false);
            }
        } else if (fast) {
            if (ratio == -2.0f) {
                this.pageLayout.addFastView(id);
            } else {
                this.pageLayout.addFastView(id, ratio);
            }
        } else {
            if (ratio == -2.0f || ratio == -1.0f) {
                ratio = 0.5f;
            }
            if (visible) {
                if (VAL_TRUE.equals(standalone)) {
                    this.pageLayout.addStandaloneView(id, !VAL_FALSE.equals(showTitle), intRelation, ratio, relative);
                } else {
                    this.pageLayout.addView(id, intRelation, ratio, relative, minimized);
                }
            } else if (VAL_TRUE.equals(standalone)) {
                this.pageLayout.addStandaloneViewPlaceholder(id, intRelation, ratio, relative, !VAL_FALSE.equals(showTitle));
            } else {
                this.pageLayout.addPlaceholder(id, intRelation, ratio, relative);
            }
        }
        IViewLayout viewLayout = this.pageLayout.getViewLayout(id);
        if (viewLayout != null) {
            if (closeable != null) {
                viewLayout.setCloseable(!VAL_FALSE.equals(closeable));
            }
            if (moveable != null) {
                viewLayout.setMoveable(!VAL_FALSE.equals(moveable));
            }
        }
        return true;
    }

    private boolean processViewShortcut(IConfigurationElement element) {
        String id = element.getAttribute("id");
        if (id != null) {
            this.pageLayout.addShowViewShortcut(id);
        }
        return true;
    }

    private boolean processWizardShortcut(IConfigurationElement element) {
        String id = element.getAttribute("id");
        if (id != null) {
            this.pageLayout.addNewWizardShortcut(id);
        }
        return true;
    }

    private boolean processEditorOnboardingText(String text) {
        if (text != null) {
            this.pageLayout.setEditorOnboardingText(text);
        }
        return true;
    }

    private boolean processEditorOnboardingImage(IConfigurationElement element, String imageUri) {
        String namespaceId;
        ImageDescriptor descriptor;
        if (imageUri != null && (descriptor = (ImageDescriptor)ResourceLocator.imageDescriptorFromBundle((String)(namespaceId = element.getNamespaceIdentifier()), (String)imageUri).orElse(null)) != null) {
            this.pageLayout.setEditorOnboardingImageUri(MenuHelper.getImageUrl(descriptor));
        }
        return true;
    }

    private boolean processEditorOnboardingCommand(IConfigurationElement element) {
        String id = element.getAttribute("id");
        if (id != null) {
            this.pageLayout.addEditorOnboardingCommandId(id);
        }
        return true;
    }

    @Override
    protected boolean readElement(IConfigurationElement element) {
        String type = element.getName();
        if (type.equals("perspectiveExtension")) {
            String id = element.getAttribute("targetID");
            if (this.targetID.equals(id) || "*".equals(id)) {
                if (this.tracker != null) {
                    this.tracker.registerObject(element.getDeclaringExtension(), (Object)new DirtyPerspectiveMarker(id), 0);
                }
                return this.processExtension(element);
            }
            return true;
        }
        return false;
    }

    public void setIncludeOnlyTags(String[] tags) {
        this.includeOnlyTags = new HashSet<String>();
        this.includeOnlyTags.addAll(Arrays.asList(tags));
    }
}

