/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gprof.view;

import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.linuxtools.binutils.link2source.STLink2SourceSupport;
import org.eclipse.linuxtools.dataviewers.abstractviewers.AbstractSTTreeViewer;
import org.eclipse.linuxtools.dataviewers.abstractviewers.ISTDataViewersField;
import org.eclipse.linuxtools.internal.gprof.Activator;
import org.eclipse.linuxtools.internal.gprof.view.FileHistogramContentProvider;
import org.eclipse.linuxtools.internal.gprof.view.fields.CallsProfField;
import org.eclipse.linuxtools.internal.gprof.view.fields.NameProfField;
import org.eclipse.linuxtools.internal.gprof.view.fields.RatioProfField;
import org.eclipse.linuxtools.internal.gprof.view.fields.SamplePerCallField;
import org.eclipse.linuxtools.internal.gprof.view.fields.SampleProfField;
import org.eclipse.linuxtools.internal.gprof.view.histogram.HistRoot;
import org.eclipse.linuxtools.internal.gprof.view.histogram.TreeElement;
import org.eclipse.swt.widgets.Composite;

public class GmonViewer
extends AbstractSTTreeViewer {
    private ISTDataViewersField[] fields;

    public GmonViewer(Composite parent) {
        super(parent);
    }

    protected TreeViewer createViewer(Composite parent, int style) {
        TreeViewer tv = super.createViewer(parent, style);
        tv.setAutoExpandLevel(2);
        return tv;
    }

    protected ITreeContentProvider createContentProvider() {
        return FileHistogramContentProvider.sharedInstance;
    }

    public ISTDataViewersField[] getAllFields() {
        if (this.fields == null) {
            this.fields = new ISTDataViewersField[]{new NameProfField(), new SampleProfField(this), new CallsProfField(), new SamplePerCallField(this), new RatioProfField()};
        }
        return this.fields;
    }

    public IDialogSettings getDialogSettings() {
        return Activator.getDefault().getDialogSettings();
    }

    protected void handleOpenEvent(OpenEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        TreeElement element = (TreeElement)selection.getFirstElement();
        if (element != null) {
            String s = element.getSourcePath();
            if (s == null || "??".equals(s)) {
                return;
            }
            int lineNumber = element.getSourceLine();
            IBinaryParser.IBinaryObject exec = ((HistRoot)element.getRoot()).decoder.getProgram();
            STLink2SourceSupport.openSourceFileAtLocation((IBinaryParser.IBinaryObject)exec, (String)s, (int)lineNumber);
        }
    }
}

