/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import org.eclipse.debug.internal.ui.views.memory.RemoveMemoryRenderingAction;
import org.eclipse.debug.internal.ui.views.memory.RenderingViewPane;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;
import org.eclipse.debug.ui.memory.IMemoryRenderingSite;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class RemoveRenderingContextAction
implements IViewActionDelegate {
    private IMemoryRenderingSite fMemoryView;

    public void init(IViewPart view) {
        if (view instanceof IMemoryRenderingSite) {
            this.fMemoryView = (IMemoryRenderingSite)view;
        }
    }

    public void run(IAction action) {
        if (this.fMemoryView == null) {
            return;
        }
        IMemoryRenderingContainer container = this.getRenderingContainer(action);
        if (container != null) {
            RemoveMemoryRenderingAction removeAction = new RemoveMemoryRenderingAction(container);
            removeAction.run();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IMemoryRenderingContainer container = this.getRenderingContainer(action);
        if (container instanceof RenderingViewPane) {
            if (!((RenderingViewPane)container).canRemoveRendering()) {
                action.setEnabled(false);
            } else {
                action.setEnabled(true);
            }
        }
    }

    private IMemoryRenderingContainer getRenderingContainer(IAction action) {
        IMemoryRenderingContainer[] viewPanes = this.fMemoryView.getMemoryRenderingContainers();
        String actionId = action.getId();
        IMemoryRenderingContainer selectedPane = null;
        IMemoryRenderingContainer[] iMemoryRenderingContainerArray = viewPanes;
        int n = viewPanes.length;
        int n2 = 0;
        while (n2 < n) {
            IMemoryRenderingContainer viewPane = iMemoryRenderingContainerArray[n2];
            if (actionId.contains(viewPane.getId())) {
                selectedPane = viewPane;
                break;
            }
            ++n2;
        }
        return selectedPane;
    }
}

