/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.MergeStrategies;
import org.eclipse.egit.core.internal.gerrit.GerritUtil;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.internal.util.ProjectUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.RevertCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.team.core.TeamException;

public class RevertCommitOperation
implements IEGitOperation {
    private final Repository repo;
    private final List<RevCommit> commits;
    private RevCommit newHead;
    private List<Ref> reverted;
    private MergeResult result;

    public RevertCommitOperation(Repository repository, List<RevCommit> commits) {
        this.repo = repository;
        this.commits = commits;
    }

    public RevCommit getNewHead() {
        return this.newHead;
    }

    public List<Ref> getRevertedRefs() {
        return this.reverted;
    }

    @Override
    public void execute(IProgressMonitor m) throws CoreException {
        IWorkspaceRunnable action = new IWorkspaceRunnable(){

            public void run(IProgressMonitor pm) throws CoreException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)pm, (int)2);
                progress.subTask(MessageFormat.format(CoreText.RevertCommitOperation_reverting, RevertCommitOperation.this.commits.size()));
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (Git git = new Git(RevertCommitOperation.this.repo);){
                        RevertCommand command = git.revert();
                        command.setInsertChangeId(GerritUtil.getCreateChangeId((Config)RevertCommitOperation.this.repo.getConfig()));
                        MergeStrategy strategy = MergeStrategies.getPreferredMergeStrategy();
                        if (strategy != null) {
                            command.setStrategy(strategy);
                        }
                        for (RevCommit commit : RevertCommitOperation.this.commits) {
                            command.include((AnyObjectId)commit);
                        }
                        RevertCommitOperation.this.newHead = command.call();
                        RevertCommitOperation.this.reverted = command.getRevertedRefs();
                        RevertCommitOperation.this.result = command.getFailingResult();
                        progress.worked(1);
                        ProjectUtil.refreshValidProjects(ProjectUtil.getValidOpenProjects(RevertCommitOperation.this.repo), (IProgressMonitor)progress.newChild(1));
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (GitAPIException e) {
                    throw new TeamException(e.getLocalizedMessage(), e.getCause());
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(action, this.getSchedulingRule(), 1, m);
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return RuleUtil.getRule(this.repo);
    }

    public MergeResult getFailingResult() {
        return this.result;
    }
}

