/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.text.MessageFormat;
import org.eclipse.mylyn.internal.tasks.ui.editors.Messages;
import org.eclipse.mylyn.internal.tasks.ui.editors.PriorityEditor;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PriorityAttributeEditor
extends AbstractAttributeEditor {
    private PriorityEditor editor;
    private ITaskMapping mapping;

    public PriorityAttributeEditor(TaskDataModel manager, TaskAttribute taskAttribute) {
        super(manager, taskAttribute);
        boolean noOptions = this.getAttributeMapper().getOptions(this.getTaskAttribute()).size() == 0;
        this.setReadOnly(this.isReadOnly() || noOptions);
    }

    @Override
    public void createControl(Composite parent, FormToolkit toolkit) {
        AbstractRepositoryConnector connector = TasksUi.getRepositoryConnector(this.getModel().getTaskRepository().getConnectorKind());
        this.mapping = connector.getTaskMapping(this.getModel().getTaskData());
        this.editor = new PriorityEditor(this.getTaskAttribute()){

            @Override
            protected void valueChanged(String value) {
                PriorityAttributeEditor.this.setValue(value);
            }
        };
        this.editor.setReadOnly(this.isReadOnly());
        this.editor.createControl(parent, toolkit);
        this.setControl(this.editor.getControl());
        this.refresh();
    }

    public String getValue() {
        return this.getAttributeMapper().getValue(this.getTaskAttribute());
    }

    public String getValueLabel() {
        return this.getAttributeMapper().getValueLabel(this.getTaskAttribute());
    }

    @Override
    public void refresh() {
        if (this.editor.getControl() != null && !this.editor.getControl().isDisposed()) {
            this.editor.setLabelByValue(this.getAttributeMapper().getOptions(this.getTaskAttribute()));
            this.updateEditor();
        }
    }

    @Override
    public boolean shouldAutoRefresh() {
        return true;
    }

    public void setValue(String value) {
        String oldValue = this.getAttributeMapper().getValue(this.getTaskAttribute());
        if (!oldValue.equals(value)) {
            this.getAttributeMapper().setValue(this.getTaskAttribute(), value);
            this.attributeChanged();
        }
    }

    private void updateEditor() {
        this.editor.select(this.getValue(), this.mapping.getPriorityLevel());
        this.editor.setToolTipText(MessageFormat.format(Messages.PriorityAttributeEditor_Priority_Tooltip, this.getValueLabel()));
    }
}

