/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.ui.actions.Messages;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class SynchronizeEditorAction
extends BaseSelectionListenerAction {
    public static final String ID = "org.eclipse.mylyn.tasklist.actions.synchronize.editor";

    public SynchronizeEditorAction() {
        super(Messages.SynchronizeEditorAction_Synchronize);
        this.setToolTipText(Messages.SynchronizeEditorAction_Synchronize_Incoming_Changes);
        this.setId(ID);
        this.setImageDescriptor(CommonImages.REFRESH_SMALL);
    }

    /*
     * WARNING - void declaration
     */
    public void run() {
        void editor;
        IStructuredSelection selection = this.getStructuredSelection();
        if (selection == null) {
            return;
        }
        Object selectedObject = selection.getFirstElement();
        if (!(selectedObject instanceof TaskEditor)) {
            return;
        }
        TaskEditor taskEditor = (TaskEditor)((Object)selectedObject);
        ITask task = editor.getTaskEditorInput().getTask();
        if (task == null) {
            return;
        }
        AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(task.getConnectorKind());
        if (connector == null) {
            return;
        }
        TasksUiInternal.synchronizeTask(connector, task, true, (IJobChangeListener)new JobChangeAdapter((TaskEditor)editor){
            private final /* synthetic */ TaskEditor val$editor;
            {
                this.val$editor = taskEditor;
            }

            public void done(IJobChangeEvent event) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                    try {
                        this.val$editor.refreshPages();
                    }
                    finally {
                        if (this.val$editor != null) {
                            this.val$editor.showBusy(false);
                        }
                    }
                });
            }
        });
        if (editor != null) {
            editor.showBusy(true);
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        Object selectedObject = selection.getFirstElement();
        if (selectedObject instanceof TaskEditor) {
            TaskEditor editor = (TaskEditor)((Object)selectedObject);
            ITask task = editor.getTaskEditorInput().getTask();
            return !(task instanceof LocalTask);
        }
        return false;
    }
}

