/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.compiler.util.ObjectVector;
import org.eclipse.jdt.internal.core.search.matching.PossibleMatch;

public class PossibleMatchSet {
    private Map<IPath, ObjectVector> rootsToPossibleMatches = new HashMap<IPath, ObjectVector>();
    private int elementCount = 0;

    public void add(PossibleMatch possibleMatch) {
        IPath path = possibleMatch.openable.getPackageFragmentRoot().getPath();
        ObjectVector possibleMatches = this.rootsToPossibleMatches.get(path);
        if (possibleMatches != null) {
            PossibleMatch storedMatch = (PossibleMatch)possibleMatches.find((Object)possibleMatch);
            if (storedMatch != null) {
                while (storedMatch.getSimilarMatch() != null) {
                    storedMatch = storedMatch.getSimilarMatch();
                }
                storedMatch.setSimilarMatch(possibleMatch);
                return;
            }
        } else {
            possibleMatches = new ObjectVector();
            this.rootsToPossibleMatches.put(path, possibleMatches);
        }
        possibleMatches.add((Object)possibleMatch);
        ++this.elementCount;
    }

    public PossibleMatch[] getPossibleMatches(IPackageFragmentRoot[] roots) {
        Object[] result = new PossibleMatch[this.elementCount];
        int index = 0;
        HashSet<IPath> processedHash = new HashSet<IPath>();
        IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
            IPath path = root.getPath();
            ObjectVector possibleMatches = this.rootsToPossibleMatches.get(path);
            if (possibleMatches != null && !processedHash.contains(path)) {
                possibleMatches.copyInto(result, index);
                index += possibleMatches.size();
                processedHash.add(path);
            }
            ++n2;
        }
        if (index < this.elementCount) {
            Object[] objectArray = result;
            result = new PossibleMatch[index];
            System.arraycopy(objectArray, 0, result, 0, index);
        }
        return result;
    }

    public void reset() {
        this.rootsToPossibleMatches = new HashMap<IPath, ObjectVector>();
        this.elementCount = 0;
    }
}

