/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.llvm.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class FindStdLibPath {
    private static final String WIN_SCRIPT = "scripts/find_path.bat";
    private static final String STD_LIB = "libstdc++.a";
    private static final String UNIX_SCRIPT = " echo `locate libstdc++.a | sort -r | head -1 | sed \"s/libstdc++.a$//\"` ";
    private static final String MAC_SCRIPT = " echo `locate libstdc++.dylib | sort -r | head -1 | sed \"s/libstdc++.dylib$//\"` ";

    public static String find() {
        ProcessBuilder pb = null;
        String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("win") >= 0) {
            pb = new ProcessBuilder("cmd", "/c", "scripts/find_path.bat libstdc++.a");
        } else if (os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0) {
            pb = new ProcessBuilder("bash", "-c", UNIX_SCRIPT);
        } else if (os.indexOf("mac") >= 0) {
            pb = new ProcessBuilder("bash", "-c", MAC_SCRIPT);
        } else {
            return null;
        }
        try {
            Process p = pb.start();
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = input.readLine();
            input.close();
            if (line != null) {
                return line;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

