/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.disassembly.viewer;

import org.eclipse.cdt.debug.ui.disassembly.IDocumentPresentation;
import org.eclipse.cdt.debug.ui.disassembly.IDocumentUpdate;
import org.eclipse.debug.internal.core.commands.Request;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.viewers.TreePath;

public abstract class DocumentUpdate
extends Request
implements IDocumentUpdate {
    private Object fRootElement;
    private Object fBaseElement;
    private Object fElement;
    private IDocumentPresentation fPresentationContext;
    private boolean fDone = false;
    private boolean fStarted = false;

    public DocumentUpdate(IDocumentPresentation presentationContext, Object rootElement, Object baseElement, Object element) {
        this.fRootElement = rootElement;
        this.fBaseElement = baseElement;
        this.fElement = element;
        this.fPresentationContext = presentationContext;
    }

    @Override
    public Object getBaseElement() {
        return this.fBaseElement;
    }

    @Override
    public Object getRootElement() {
        return this.fRootElement;
    }

    public Object getElement() {
        return this.fElement;
    }

    public TreePath getElementPath() {
        return null;
    }

    public IPresentationContext getPresentationContext() {
        return this.fPresentationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void start() {
        DocumentUpdate documentUpdate = this;
        synchronized (documentUpdate) {
            if (this.fStarted) {
                return;
            }
            this.fStarted = true;
        }
        if (!this.isCanceled()) {
            this.startRequest();
        } else {
            this.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() {
        DocumentUpdate documentUpdate = this;
        synchronized (documentUpdate) {
            if (this.isDone()) {
                return;
            }
            this.fDone = true;
        }
    }

    void setRootElement(Object rootElement) {
        this.fRootElement = rootElement;
    }

    void setBaseElement(Object baseElement) {
        this.fBaseElement = baseElement;
    }

    protected synchronized boolean isDone() {
        return this.fDone;
    }

    abstract void startRequest();

    public Object getViewerInput() {
        return null;
    }
}

