/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.disassembly.viewer;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.debug.internal.ui.disassembly.editor.DisassemblyEditorInput;
import org.eclipse.cdt.debug.internal.ui.disassembly.editor.DisassemblyEditorPresentation;
import org.eclipse.cdt.debug.internal.ui.disassembly.viewer.VirtualDocument;
import org.eclipse.cdt.debug.ui.disassembly.IDocumentPresentation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IElementStateListener;

public class DisassemblyDocumentProvider
implements IDocumentProvider {
    private Map<Object, DocumentInfo> fDocumentInfos = new HashMap<Object, DocumentInfo>();

    public void aboutToChange(Object element) {
    }

    public void addElementStateListener(IElementStateListener listener) {
    }

    public boolean canSaveDocument(Object element) {
        return false;
    }

    public void changed(Object element) {
    }

    public synchronized void connect(Object element) throws CoreException {
        Object disassemblyContext = ((DisassemblyEditorInput)element).getDisassemblyContext();
        if (this.fDocumentInfos.get(disassemblyContext) == null) {
            IDocumentPresentation presentation = this.createDocumentPresentation(disassemblyContext);
            AnnotationModel annotationModel = this.createAnnotationModel();
            VirtualDocument document = this.createDocument(disassemblyContext, presentation, annotationModel);
            this.fDocumentInfos.put(disassemblyContext, new DocumentInfo(document, (IAnnotationModel)annotationModel, presentation));
        }
    }

    public synchronized void disconnect(Object element) {
        Object disassemblyContext = ((DisassemblyEditorInput)element).getDisassemblyContext();
        DocumentInfo info = this.fDocumentInfos.remove(disassemblyContext);
        if (info != null) {
            info.dispose();
        }
    }

    public IAnnotationModel getAnnotationModel(Object element) {
        Object disassemblyContext = ((DisassemblyEditorInput)element).getDisassemblyContext();
        DocumentInfo info = this.fDocumentInfos.get(disassemblyContext);
        return info != null ? info.getAnnotationModel() : null;
    }

    public IDocument getDocument(Object element) {
        Object disassemblyContext = ((DisassemblyEditorInput)element).getDisassemblyContext();
        DocumentInfo info = this.fDocumentInfos.get(disassemblyContext);
        return info != null ? info.getDocument() : null;
    }

    public long getModificationStamp(Object element) {
        return 0L;
    }

    public long getSynchronizationStamp(Object element) {
        return 0L;
    }

    public boolean isDeleted(Object element) {
        return false;
    }

    public boolean mustSaveDocument(Object element) {
        return false;
    }

    public void removeElementStateListener(IElementStateListener listener) {
    }

    public void resetDocument(Object element) throws CoreException {
    }

    public void saveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
    }

    public void dispose() {
        for (DocumentInfo info : this.fDocumentInfos.values()) {
            info.dispose();
        }
        this.fDocumentInfos.clear();
    }

    public IDocumentPresentation getDocumentPresentation(Object element) {
        Object disassemblyContext = ((DisassemblyEditorInput)element).getDisassemblyContext();
        DocumentInfo info = this.fDocumentInfos.get(disassemblyContext);
        return info != null ? info.getPresentation() : null;
    }

    private AnnotationModel createAnnotationModel() {
        return new AnnotationModel();
    }

    private VirtualDocument createDocument(Object disassemblyContext, IDocumentPresentation presentationContext, AnnotationModel annotationModel) {
        return new VirtualDocument(annotationModel, presentationContext, disassemblyContext);
    }

    private IDocumentPresentation createDocumentPresentation(Object context) {
        return new DisassemblyEditorPresentation();
    }

    class DocumentInfo {
        private VirtualDocument fDocument;
        private IAnnotationModel fAnnotationModel;
        private IDocumentPresentation fPresentation;

        DocumentInfo(VirtualDocument document, IAnnotationModel annotationModel, IDocumentPresentation presentation) {
            this.fDocument = document;
            this.fAnnotationModel = annotationModel;
            this.fPresentation = presentation;
        }

        VirtualDocument getDocument() {
            return this.fDocument;
        }

        IAnnotationModel getAnnotationModel() {
            return this.fAnnotationModel;
        }

        IDocumentPresentation getPresentation() {
            return this.fPresentation;
        }

        void dispose() {
            this.fPresentation.dispose();
            this.fPresentation = null;
            this.fAnnotationModel = null;
            this.fDocument.dispose();
            this.fDocument = null;
        }
    }
}

