/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cdt.debug.core.model.ICastToType;
import org.eclipse.cdt.debug.internal.ui.CDebugImages;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class CastToTypeActionHandler
extends AbstractHandler {
    private ICastToType[] fCastableItems = new ICastToType[0];
    private IStatus fStatus = null;
    private IWorkbenchPart fTargetPart;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.fTargetPart = HandlerUtil.getActivePartChecked((ExecutionEvent)event);
        if (this.getCastToType() == null || this.getCastToType().length == 0) {
            return null;
        }
        BusyIndicator.showWhile((Display)Display.getCurrent(), () -> {
            try {
                this.doAction(this.getCastToType());
                this.setStatus(null);
            }
            catch (DebugException e) {
                this.setStatus(e.getStatus());
            }
        });
        if (this.getStatus() != null && !this.getStatus().isOK()) {
            IWorkbenchWindow window = CDebugUIPlugin.getActiveWorkbenchWindow();
            if (window != null) {
                CDebugUIPlugin.errorDialog(ActionMessages.getString("CastToTypeActionDelegate.3"), this.getStatus());
            } else {
                CDebugUIPlugin.log(this.getStatus());
            }
        }
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        ICastToType[] castableItems = this.getCastToType(evaluationContext);
        this.setBaseEnabled(castableItems.length > 0);
        this.setCastToType(castableItems);
    }

    private ICastToType[] getCastToType(Object evaluationContext) {
        Object s;
        ArrayList<ICastToType> castableItems = new ArrayList<ICastToType>();
        if (evaluationContext instanceof IEvaluationContext && (s = ((IEvaluationContext)evaluationContext).getVariable("activeMenuSelection")) instanceof IStructuredSelection) {
            Iterator iter = ((IStructuredSelection)s).iterator();
            while (iter.hasNext()) {
                Object element = DebugPlugin.getAdapter(iter.next(), ICastToType.class);
                if (!(element instanceof ICastToType) || !((ICastToType)element).canCast()) continue;
                castableItems.add((ICastToType)element);
            }
        }
        return castableItems.toArray(new ICastToType[castableItems.size()]);
    }

    protected ICastToType[] getCastToType() {
        return this.fCastableItems;
    }

    protected void setCastToType(ICastToType[] castableItems) {
        this.fCastableItems = castableItems;
    }

    public IStatus getStatus() {
        return this.fStatus;
    }

    public void setStatus(IStatus status) {
        this.fStatus = status;
    }

    protected void doAction(ICastToType[] castableItems) throws DebugException {
        String currentType = castableItems[0].getCurrentType().trim();
        CastToTypeDialog dialog = new CastToTypeDialog(CDebugUIPlugin.getActiveWorkbenchShell(), currentType);
        if (dialog.open() == 0) {
            String newType = dialog.getValue().trim();
            ICastToType[] iCastToTypeArray = castableItems;
            int n = castableItems.length;
            int n2 = 0;
            while (n2 < n) {
                ICastToType castableItem = iCastToTypeArray[n2];
                castableItem.cast(newType);
                ++n2;
            }
            if (this.getSelectionProvider() != null) {
                this.getSelectionProvider().setSelection((ISelection)new StructuredSelection((Object[])castableItems));
            }
        }
    }

    private ISelectionProvider getSelectionProvider() {
        return this.fTargetPart instanceof IDebugView ? ((IDebugView)this.fTargetPart).getViewer() : null;
    }

    protected class CastToTypeDialog
    extends InputDialog {
        public CastToTypeDialog(Shell parentShell, String initialValue) {
            super(parentShell, ActionMessages.getString("CastToTypeActionDelegate.1"), ActionMessages.getString("CastToTypeActionDelegate.2"), initialValue, (IInputValidator)new CastToTypeInputValidator());
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setImage(CDebugImages.get("org.eclipse.cdt.debug.ui.casttotype_co.gif"));
        }
    }

    protected static class CastToTypeInputValidator
    implements IInputValidator {
        public String isValid(String newText) {
            if (newText.trim().length() == 0) {
                return ActionMessages.getString("CastToTypeActionDelegate.0");
            }
            return null;
        }
    }
}

