/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.resources.ui;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.resources.ui.ResourcesUiBridgePlugin;
import org.eclipse.mylyn.monitor.core.InteractionEvent;

public final class ResourcesUi {
    public static void addResourceToContext(Set<IResource> resources, InteractionEvent.Kind interactionKind) {
        ResourcesUiBridgePlugin.getInterestUpdater().addResourceToContext(resources, interactionKind);
    }

    public static Set<IProject> getProjects(IInteractionContext context) {
        List allElements = context.getAllElements();
        HashSet<IProject> projectsInContext = new HashSet<IProject>();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        LinkedList<IProject> projectsInWorkspace = new LinkedList<IProject>();
        IProject[] iProjectArray = workspace.getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            if (p.exists()) {
                projectsInWorkspace.add(p);
            }
            ++n2;
        }
        for (IInteractionElement element : allElements) {
            String handle = element.getHandleIdentifier();
            Path path = new Path(handle);
            if (path.segmentCount() != 1 || !path.isValidPath(handle)) continue;
            String projectName = handle.substring(1);
            IProject project = workspace.getRoot().getProject(projectName);
            if (!projectsInWorkspace.contains(project)) continue;
            projectsInContext.add(project);
        }
        return projectsInContext;
    }
}

