/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.resources.ui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.internal.resources.ui.IResourceExclusionStrategy;
import org.eclipse.mylyn.internal.resources.ui.ResourceModifiedDateExclusionStrategy;
import org.eclipse.mylyn.internal.resources.ui.ResourcePatternExclusionStrategy;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.eclipse.mylyn.resources.ui.ResourcesUi;

public class ResourceChangeMonitor
implements IResourceChangeListener {
    private static final int MAX_FILE_DELTA_SIZE = 10;
    private static final int MAX_NEW_FOLDER_DELTA_SIZE = 3;
    private boolean enabled = true;
    private final List<IResourceExclusionStrategy> exclusions = new ArrayList<IResourceExclusionStrategy>();

    public ResourceChangeMonitor() {
        this.exclusions.add(new ResourcePatternExclusionStrategy());
        this.exclusions.add(new ResourceModifiedDateExclusionStrategy());
        for (IResourceExclusionStrategy exclusion : this.exclusions) {
            exclusion.init();
        }
    }

    public void dispose() {
        for (IResourceExclusionStrategy exclusion : this.exclusions) {
            exclusion.dispose();
        }
        this.exclusions.clear();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (!this.enabled || !ContextCore.getContextManager().isContextActive() || event.getType() != 1) {
            return;
        }
        IResourceDelta rootDelta = event.getDelta();
        if (rootDelta != null) {
            ResourceDeltaVisitor visitor = new ResourceDeltaVisitor(this.exclusions);
            try {
                rootDelta.accept((IResourceDeltaVisitor)visitor, 10);
                if (visitor.hasValidResult() && visitor.getNumChangedAndAddedFiles() <= 10 && visitor.getNumAddedFolders() <= 3) {
                    ResourcesUi.addResourceToContext(visitor.getChangedResources(), InteractionEvent.Kind.PREDICTION);
                    ResourcesUi.addResourceToContext(visitor.getAddedResources(), InteractionEvent.Kind.PROPAGATION);
                }
            }
            catch (CoreException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.resources.ui", "Could not accept marker visitor", (Throwable)e));
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    private class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        private final Set<IResource> addedResources;
        private final Set<IResource> changedResources;
        private boolean haveTeamPrivateMember;
        private final List<IResourceExclusionStrategy> resourceExclusions;
        private int numNonExcludedFiles = 0;
        private int numAddedFolders = 0;

        public ResourceDeltaVisitor(List<IResourceExclusionStrategy> resourceExclusions) {
            this.resourceExclusions = resourceExclusions;
            this.addedResources = new HashSet<IResource>();
            this.changedResources = new HashSet<IResource>();
            for (IResourceExclusionStrategy exclusion : ResourceChangeMonitor.this.exclusions) {
                exclusion.update();
            }
        }

        public boolean hasValidResult() {
            return !this.haveTeamPrivateMember;
        }

        public boolean visit(IResourceDelta delta) {
            IResourceDelta[] changed;
            IResourceDelta[] added;
            IResource deltaResource = delta.getResource();
            if (deltaResource instanceof IProject && (delta.getKind() == 2 || (delta.getFlags() & 0x4000) != 0) || this.hasTeamPrivate(deltaResource)) {
                return false;
            }
            if (this.isExcluded(deltaResource)) {
                return false;
            }
            IResourceDelta[] iResourceDeltaArray = added = delta.getAffectedChildren(1);
            int n = added.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta element = iResourceDeltaArray[n2];
                IResource resource = element.getResource();
                if ((resource instanceof IFile || resource instanceof IFolder) && !this.isExcluded(resource)) {
                    if (this.hasTeamPrivate(resource)) {
                        return false;
                    }
                    if (resource instanceof IFile) {
                        ++this.numNonExcludedFiles;
                    } else if (resource instanceof IFolder) {
                        ++this.numAddedFolders;
                    }
                    this.addedResources.add(resource);
                }
                ++n2;
            }
            IResourceDelta[] iResourceDeltaArray2 = changed = delta.getAffectedChildren(6);
            int n3 = changed.length;
            n = 0;
            while (n < n3) {
                IResourceDelta element = iResourceDeltaArray2[n];
                IResource resource = element.getResource();
                if (!(!(resource instanceof IFile) || this.isExcluded(resource) || "feature.xml".equals(resource.getName()) || element.getKind() == 4 && (element.getFlags() & 0x100) == 0)) {
                    if (this.hasTeamPrivate(resource)) {
                        return false;
                    }
                    if (resource instanceof IFile) {
                        ++this.numNonExcludedFiles;
                    }
                    this.changedResources.add(resource);
                }
                ++n;
            }
            return true;
        }

        private boolean hasTeamPrivate(IResource resource) {
            if (this.haveTeamPrivateMember) {
                return true;
            }
            if (resource.isTeamPrivateMember()) {
                this.haveTeamPrivateMember = true;
                return true;
            }
            return false;
        }

        private boolean isExcluded(IResource resource) {
            for (IResourceExclusionStrategy exclusion : this.resourceExclusions) {
                if (!exclusion.isExcluded(resource)) continue;
                return true;
            }
            return false;
        }

        public Set<IResource> getChangedResources() {
            return this.changedResources;
        }

        public Set<IResource> getAddedResources() {
            return this.addedResources;
        }

        public int getNumChangedAndAddedFiles() {
            return this.numNonExcludedFiles;
        }

        public int getNumAddedFolders() {
            return this.numAddedFolders;
        }
    }
}

