/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.properties;

import java.util.ArrayList;
import org.eclipse.egit.ui.internal.PreferenceBasedDateFormatter;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class PersonIdentPropertySource
implements IPropertySource {
    private static final String PROPERTY_NAME = "name";
    private static final String PROPERTY_EMAIL = "e-mail";
    private static final String PROPERTY_DATE = "date";
    private final PersonIdent person;
    private final IPropertyDescriptor[] descriptors;

    public PersonIdentPropertySource(PersonIdent ident) {
        this.person = ident;
        ArrayList<PropertyDescriptor> result = new ArrayList<PropertyDescriptor>(3);
        result.add(new PropertyDescriptor((Object)PROPERTY_NAME, UIText.PersonIdentPropertySource_Name));
        result.add(new PropertyDescriptor((Object)PROPERTY_EMAIL, UIText.PersonIdentPropertySource_Email));
        result.add(new PropertyDescriptor((Object)PROPERTY_DATE, UIText.PersonIdentPropertySource_Date));
        String category = ident.toExternalString();
        for (PropertyDescriptor desc : result) {
            desc.setCategory(category);
        }
        this.descriptors = result.toArray(new IPropertyDescriptor[0]);
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return this.descriptors;
    }

    public Object getPropertyValue(Object id) {
        switch (id.toString()) {
            case "name": {
                return this.person.getName();
            }
            case "e-mail": {
                return this.person.getEmailAddress();
            }
            case "date": {
                return PreferenceBasedDateFormatter.create().formatDate(this.person);
            }
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public String toString() {
        return this.person.toExternalString();
    }
}

