/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.clone;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.internal.gerrit.GerritUtil;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.dialogs.FinishableWizardDialog;
import org.eclipse.egit.ui.internal.repository.RepositoriesViewContentProvider;
import org.eclipse.egit.ui.internal.repository.RepositorySearchWizard;
import org.eclipse.egit.ui.internal.repository.RepositoryTreeNodeLabelProvider;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class GitSelectRepositoryPage
extends WizardPage {
    private static final String LAST_SELECTED_REPO_PREF = "GitSelectRepositoryPage.lastRepository";
    private final boolean allowBare;
    private final boolean allowAdd;
    private TreeViewer tv;
    private Button addRepo;
    private Composite bareMsg;
    private IEclipsePreferences.IPreferenceChangeListener configChangeListener;

    public GitSelectRepositoryPage() {
        this(true, true);
    }

    public GitSelectRepositoryPage(boolean allowBare) {
        this(allowBare, true);
    }

    public GitSelectRepositoryPage(boolean allowBare, boolean allowAdd) {
        super(GitSelectRepositoryPage.class.getName());
        this.setTitle(UIText.GitSelectRepositoryPage_PageTitle);
        this.setDescription(UIText.GitSelectRepositoryPage_PageMessage);
        this.allowBare = allowBare;
        this.allowAdd = allowAdd;
    }

    public Repository getRepository() {
        Object obj = ((IStructuredSelection)this.tv.getSelection()).getFirstElement();
        if (obj == null) {
            return null;
        }
        return ((RepositoryTreeNode)obj).getRepository();
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(this.allowAdd ? 2 : 1).margins(0, 0).applyTo(main);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)main);
        FilteredTree tree = new FilteredTree(main, 2820, new PatternFilter(), true, true);
        this.tv = tree.getViewer();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tree);
        this.tv.setContentProvider((IContentProvider)new RepositoriesViewContentProvider(){

            @Override
            public Object[] getElements(Object inputElement) {
                Object[] elements = super.getElements(inputElement);
                if (GitSelectRepositoryPage.this.allowBare) {
                    return elements;
                }
                ArrayList<Object> result = new ArrayList<Object>();
                Object[] objectArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    RepositoryTreeNode node;
                    Object element = objectArray[n2];
                    if (element instanceof RepositoryTreeNode && (node = (RepositoryTreeNode)element).getRepository() != null && !node.getRepository().isBare()) {
                        result.add(element);
                    }
                    ++n2;
                }
                GitSelectRepositoryPage.this.bareMsg.setVisible(result.size() != elements.length);
                return result.toArray();
            }

            @Override
            public Object[] getChildren(Object parentElement) {
                return null;
            }

            @Override
            public boolean hasChildren(Object element) {
                return false;
            }
        });
        this.tv.setLabelProvider((IBaseLabelProvider)new RepositoryTreeNodeLabelProvider(true));
        this.tv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                GitSelectRepositoryPage.this.checkPage();
            }
        });
        this.tv.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                GitSelectRepositoryPage.this.checkPage();
                if (GitSelectRepositoryPage.this.isPageComplete()) {
                    IWizardContainer container = GitSelectRepositoryPage.this.getContainer();
                    IWizardPage next = GitSelectRepositoryPage.this.getNextPage();
                    if (next != null) {
                        container.showPage(next);
                    } else if (container instanceof FinishableWizardDialog) {
                        ((FinishableWizardDialog)container).finish();
                    }
                }
            }
        });
        if (this.allowAdd) {
            Composite tb = new Composite(main, 0);
            GridLayoutFactory.fillDefaults().numColumns(1).applyTo(tb);
            GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)tb);
            this.addRepo = new Button(tb, 8);
            GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)this.addRepo);
            this.addRepo.setText(UIText.GitSelectRepositoryPage_AddButton);
            this.addRepo.setToolTipText(UIText.GitSelectRepositoryPage_AddTooltip);
            this.addRepo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    List configuredDirs = RepositoryUtil.INSTANCE.getConfiguredRepositories();
                    RepositorySearchWizard wizard = new RepositorySearchWizard(configuredDirs, GitSelectRepositoryPage.this.allowBare);
                    WizardDialog dlg = new WizardDialog(GitSelectRepositoryPage.this.getShell(), (IWizard)wizard){

                        protected Button createButton(Composite container, int id, String label, boolean defaultButton) {
                            if (id == 16) {
                                return super.createButton(container, id, UIText.AddCommand_AddButtonLabel, defaultButton);
                            }
                            return super.createButton(container, id, label, defaultButton);
                        }
                    };
                    if (dlg.open() == 0 && !wizard.getDirectories().isEmpty()) {
                        Set<String> dirs = wizard.getDirectories();
                        for (String dir : dirs) {
                            File gitDir = FileUtils.canonicalize((File)new File(dir));
                            GerritUtil.tryToAutoConfigureForGerrit((File)gitDir);
                            RepositoryUtil.INSTANCE.addConfiguredRepository(gitDir);
                        }
                        GitSelectRepositoryPage.this.checkPage();
                    }
                }
            });
        }
        if (!this.allowBare) {
            this.bareMsg = new Composite(main, 0);
            this.bareMsg.setLayout((Layout)new RowLayout());
            this.bareMsg.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
            Label imageLabel = new Label(this.bareMsg, 0);
            imageLabel.setImage(JFaceResources.getImage((String)"dialog_messasge_info_image"));
            Label textLabel = new Label(this.bareMsg, 64);
            textLabel.setText(UIText.GitSelectRepositoryPage_BareRepositoriesHidden);
            this.bareMsg.setVisible(false);
        }
        this.tv.setInput(this.getInitialRepositories());
        this.configChangeListener = new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                if ("GitRepositoriesView.GitDirectories.relative".equals(event.getKey())) {
                    Display display = GitSelectRepositoryPage.this.tv.getControl().getDisplay();
                    display.asyncExec(() -> {
                        if (!GitSelectRepositoryPage.this.tv.getControl().isDisposed()) {
                            GitSelectRepositoryPage.this.refreshRepositoryList();
                            GitSelectRepositoryPage.this.checkPage();
                        }
                    });
                }
            }
        };
        RepositoryUtil.INSTANCE.getPreferences().addPreferenceChangeListener(this.configChangeListener);
        this.setPageComplete(false);
        if (this.tv.getTree().getItemCount() == 0 && !this.allowAdd) {
            this.setErrorMessage(UIText.GitSelectRepositoryPage_NoRepository);
        }
        Dialog.applyDialogFont((Control)main);
        this.setControl((Control)main);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        if (visible && this.tv.getSelection().isEmpty()) {
            String repoDir = settings.get(LAST_SELECTED_REPO_PREF);
            if (repoDir != null) {
                TreeItem[] treeItemArray = this.tv.getTree().getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    RepositoryNode node = (RepositoryNode)item.getData();
                    if (node.getRepository().getDirectory().getPath().equals(repoDir)) {
                        this.tv.setSelection((ISelection)new StructuredSelection((Object)node));
                    }
                    ++n2;
                }
            }
        } else {
            Object element = ((IStructuredSelection)this.tv.getSelection()).getFirstElement();
            if (element instanceof RepositoryNode) {
                settings.put(LAST_SELECTED_REPO_PREF, ((RepositoryNode)element).getRepository().getDirectory().getPath());
            }
        }
    }

    private void refreshRepositoryList() {
        List dirsBefore = (List)this.tv.getInput();
        List<String> dirsAfter = this.getInitialRepositories();
        if (dirsBefore == null) {
            dirsBefore = Collections.emptyList();
        }
        if (!dirsBefore.containsAll(dirsAfter)) {
            IStructuredSelection previousSelection = (IStructuredSelection)this.tv.getSelection();
            this.tv.setInput(dirsAfter);
            for (String dir : dirsAfter) {
                if (dirsBefore.contains(dir)) continue;
                try {
                    Repository newRepository = RepositoryCache.INSTANCE.lookupRepository(new File(dir));
                    if (!this.allowBare && newRepository.isBare()) {
                        if (previousSelection.isEmpty()) break;
                        this.tv.setSelection((ISelection)previousSelection);
                        break;
                    }
                    RepositoryNode node = new RepositoryNode(null, newRepository);
                    this.tv.setSelection((ISelection)new StructuredSelection((Object)node));
                }
                catch (IOException e1) {
                    Activator.handleError(e1.getMessage(), e1, false);
                }
                break;
            }
        }
    }

    private void checkPage() {
        block6: {
            block4: {
                block5: {
                    this.setErrorMessage(null);
                    try {
                        List currentInput = (List)this.tv.getInput();
                        if (currentInput != null && !currentInput.isEmpty()) break block4;
                        if (!this.allowAdd) {
                            this.setErrorMessage(UIText.GitSelectRepositoryPage_NoRepository);
                            break block5;
                        }
                        this.setErrorMessage(UIText.GitSelectRepositoryPage_NoRepoFoundMessage);
                    }
                    catch (Throwable throwable) {
                        this.setPageComplete(this.getErrorMessage() == null);
                        throw throwable;
                    }
                }
                this.setPageComplete(this.getErrorMessage() == null);
                return;
            }
            if (!this.tv.getSelection().isEmpty()) break block6;
            this.setErrorMessage(UIText.GitSelectRepositoryPage_PleaseSelectMessage);
            this.setPageComplete(this.getErrorMessage() == null);
            return;
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    public void dispose() {
        super.dispose();
        RepositoryUtil.INSTANCE.getPreferences().removePreferenceChangeListener(this.configChangeListener);
    }

    protected List<String> getInitialRepositories() {
        return RepositoryUtil.INSTANCE.getConfiguredRepositories();
    }
}

