/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.commands;

import java.util.ArrayList;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.mi.service.command.commands.MICommand;
import org.eclipse.cdt.dsf.mi.service.command.output.MIListThreadGroupsInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;

public class MIListThreadGroups
extends MICommand<MIListThreadGroupsInfo> {
    public MIListThreadGroups(ICommandControlService.ICommandControlDMContext ctx) {
        this(ctx, false);
    }

    public MIListThreadGroups(ICommandControlService.ICommandControlDMContext ctx, String groupId) {
        this(ctx, groupId, false, false);
    }

    public MIListThreadGroups(ICommandControlService.ICommandControlDMContext ctx, boolean listAll) {
        this(ctx, null, listAll, false);
    }

    public MIListThreadGroups(ICommandControlService.ICommandControlDMContext ctx, boolean listAll, boolean recurse) {
        this(ctx, null, listAll, recurse);
    }

    private MIListThreadGroups(ICommandControlService.ICommandControlDMContext ctx, String groupId, boolean listAll, boolean recurse) {
        super((IDMContext)ctx, "-list-thread-groups");
        assert (groupId == null || !listAll);
        ArrayList<String> arguments = new ArrayList<String>();
        if (listAll) {
            arguments.add("--available");
        }
        if (recurse) {
            arguments.add("--recurse");
            arguments.add("1");
        }
        if (groupId != null) {
            assert (groupId.trim().length() > 0);
            arguments.add(groupId);
        }
        if (!arguments.isEmpty()) {
            this.setParameters(arguments.toArray(new String[0]));
        }
    }

    @Override
    public MIListThreadGroupsInfo getResult(MIOutput out) {
        return new MIListThreadGroupsInfo(out);
    }
}

