/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.wizards;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

abstract class AbstractWizardPage
extends WizardPage
implements Listener {
    protected AbstractWizardPage(String pageName) {
        super(pageName);
    }

    protected AbstractWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public final void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite topLevel = new Composite(parent, 0);
        topLevel.setLayout((Layout)new GridLayout());
        topLevel.setLayoutData((Object)new GridData(272));
        topLevel.setFont(parent.getFont());
        this.createBody(topLevel);
        this.initializeDefaultValues();
        this.setControl((Control)topLevel);
    }

    public void handleEvent(Event event) {
        this.validateAndUpdateStatus(event);
    }

    private void validateAndUpdateStatus(Event event) {
        IStatus status = this.validatePage(event);
        this.statusChanged(status == null ? Status.OK_STATUS : status);
    }

    void statusChanged(IStatus status) {
        this.setPageComplete(!status.matches(4));
        AbstractWizardPage.applyToStatusLine((DialogPage)this, status);
    }

    private static void applyToStatusLine(DialogPage page, IStatus status) {
        String message = Status.OK_STATUS.equals(status) ? null : status.getMessage();
        switch (status.getSeverity()) {
            case 0: {
                page.setMessage(message, 0);
                page.setErrorMessage(null);
                break;
            }
            case 2: {
                page.setMessage(message, 2);
                page.setErrorMessage(null);
                break;
            }
            case 1: {
                page.setMessage(message, 1);
                page.setErrorMessage(null);
                break;
            }
            default: {
                if (message != null && message.isEmpty()) {
                    message = null;
                }
                page.setMessage(null);
                page.setErrorMessage(message);
            }
        }
    }

    protected abstract void createBody(Composite var1);

    protected abstract void initializeDefaultValues();

    protected abstract @Nullable IStatus validatePage(Event var1);
}

