/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.documentation;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ui.documentation.DocumentationResponseDelegate;
import org.eclipse.dltk.ui.documentation.DocumentationUtils;
import org.eclipse.dltk.ui.documentation.IDocumentationResponse;
import org.eclipse.dltk.ui.documentation.IScriptDocumentationProvider;
import org.eclipse.dltk.ui.documentation.IScriptDocumentationProviderExtension;
import org.eclipse.dltk.ui.documentation.IScriptDocumentationProviderExtension2;
import org.eclipse.dltk.ui.documentation.IScriptDocumentationTitleAdapter;
import org.eclipse.dltk.utils.AdaptUtils;
import org.eclipse.dltk.utils.NatureExtensionManager;

public class ScriptDocumentationAccess {
    private static final String DOCUMENTATION_PROVIDERS_EXTENSION_POINT = "org.eclipse.dltk.ui.scriptDocumentationProviders";
    private static final NatureExtensionManager<IScriptDocumentationProvider> providers = new NatureExtensionManager<IScriptDocumentationProvider>("org.eclipse.dltk.ui.scriptDocumentationProviders", IScriptDocumentationProvider.class){

        protected void initializeDescriptors(List<Object> descriptors) {
            Collections.sort(descriptors, new Comparator<Object>(){

                int priority(IConfigurationElement element) {
                    try {
                        return Integer.parseInt(element.getAttribute("priority"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        return 0;
                    }
                }

                @Override
                public int compare(Object o1, Object o2) {
                    return this.priority((IConfigurationElement)o2) - this.priority((IConfigurationElement)o1);
                }
            });
        }

        protected IScriptDocumentationProvider[] createEmptyResult() {
            return new IScriptDocumentationProvider[0];
        }
    };
    private static final int BUFF_SIZE = 2048;

    private ScriptDocumentationAccess() {
    }

    private static IScriptDocumentationProvider[] getProviders(String nature) {
        return (IScriptDocumentationProvider[])providers.getInstances(nature);
    }

    private static Reader merge(String nature, Operation operation) {
        StringBuilder buffer = new StringBuilder();
        char[] buff = null;
        IScriptDocumentationProvider[] iScriptDocumentationProviderArray = ScriptDocumentationAccess.getProviders(nature);
        int n = iScriptDocumentationProviderArray.length;
        int n2 = 0;
        while (n2 < n) {
            block8: {
                IScriptDocumentationProvider p = iScriptDocumentationProviderArray[n2];
                Reader reader = operation.getInfo(p);
                if (reader != null) {
                    if (buffer.length() != 0) {
                        buffer.append("<hr/>");
                    }
                    if (buff == null) {
                        buff = new char[2048];
                    }
                    try {
                        int len;
                        while ((len = reader.read(buff, 0, 2048)) != -1) {
                            buffer.append(buff, 0, len);
                        }
                    }
                    catch (IOException e) {
                        if (!DLTKCore.DEBUG) break block8;
                        e.printStackTrace();
                    }
                }
            }
            ++n2;
        }
        if (buffer.length() > 0) {
            char[] cnt = new char[buffer.length()];
            buffer.getChars(0, buffer.length(), cnt, 0);
            return new CharArrayReader(cnt);
        }
        return null;
    }

    private static IDocumentationResponse merge(String nature, Operation2 operation) {
        IScriptDocumentationProvider[] iScriptDocumentationProviderArray = ScriptDocumentationAccess.getProviders(nature);
        int n = iScriptDocumentationProviderArray.length;
        int n2 = 0;
        while (n2 < n) {
            IScriptDocumentationProvider p = iScriptDocumentationProviderArray[n2];
            IDocumentationResponse response = operation.getInfo(p);
            if (response != null) {
                return response;
            }
            ++n2;
        }
        return null;
    }

    public static Reader getHTMLContentReader(String nature, final Object member, final boolean allowInherited, final boolean allowExternal) {
        return ScriptDocumentationAccess.merge(nature, new Operation(){

            public Reader getInfo(IScriptDocumentationProvider provider) {
                if (member instanceof IMember) {
                    return provider.getInfo((IMember)member, allowInherited, allowExternal);
                }
                if (provider instanceof IScriptDocumentationProviderExtension2) {
                    IScriptDocumentationProviderExtension2 ext = (IScriptDocumentationProviderExtension2)((Object)provider);
                    IDocumentationResponse response = ext.getDocumentationFor(member);
                    return DocumentationUtils.getReader(response);
                }
                return null;
            }
        });
    }

    public static IDocumentationResponse getDocumentation(String nature, final Object member, final Object context) {
        return ScriptDocumentationAccess.merge(nature, new Operation2(){

            public IDocumentationResponse getInfo(IScriptDocumentationProvider provider) {
                if (provider instanceof IScriptDocumentationProviderExtension2) {
                    String title;
                    IScriptDocumentationTitleAdapter titleAdapter;
                    IScriptDocumentationProviderExtension2 ext = (IScriptDocumentationProviderExtension2)((Object)provider);
                    IDocumentationResponse response = ext.getDocumentationFor(member);
                    if (response != null && response.getTitle() == null && (titleAdapter = (IScriptDocumentationTitleAdapter)AdaptUtils.getAdapter((Object)context, IScriptDocumentationTitleAdapter.class)) != null && (title = titleAdapter.getTitle(member)) != null && title.length() != 0) {
                        return new DocumentationResponseDelegate(response){

                            public String getTitle() {
                                return title;
                            }
                        };
                    }
                    return response;
                }
                if (member instanceof IMember) {
                    IMember m = (IMember)member;
                    return DocumentationUtils.wrap(member, context, provider.getInfo(m, true, true));
                }
                return null;
            }
        });
    }

    @Deprecated
    public static Reader getHTMLContentReader(String nature, final String content) throws ModelException {
        return ScriptDocumentationAccess.merge(nature, new Operation(){

            public Reader getInfo(IScriptDocumentationProvider provider) {
                return provider.getInfo(content);
            }
        });
    }

    public static Reader getKeywordDocumentation(String nature, final IModelElement context, final String keyword) throws ModelException {
        return ScriptDocumentationAccess.merge(nature, new Operation(){

            public Reader getInfo(IScriptDocumentationProvider provider) {
                if (provider instanceof IScriptDocumentationProviderExtension) {
                    IScriptDocumentationProviderExtension ext = (IScriptDocumentationProviderExtension)((Object)provider);
                    IDocumentationResponse response = ext.describeKeyword(keyword, context);
                    return DocumentationUtils.getReader(response);
                }
                return provider.getInfo(keyword);
            }
        });
    }

    private static interface Operation {
        public Reader getInfo(IScriptDocumentationProvider var1);
    }

    private static interface Operation2 {
        public IDocumentationResponse getInfo(IScriptDocumentationProvider var1);
    }
}

