/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.flash.ui.properties;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.actf.accservice.swtbridge.MSAA;
import org.eclipse.actf.model.flash.ASAccInfo;
import org.eclipse.actf.model.flash.IASNode;
import org.eclipse.actf.model.flash.IFlashConst;
import org.eclipse.actf.visualization.gui.msaa.properties.AttributePropertySource;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class FlashNodePropertySource
implements IPropertySource,
IFlashConst {
    private static boolean DEBUG_MODE = false;
    private IASNode flashNode;
    public static final String PID_LOCATION = "Location";
    public static final String PID_TABINDEX = "tabIndex";
    private static final IPropertyDescriptor[] DESCRIPTORS = new IPropertyDescriptor[]{new PropertyDescriptor((Object)"objectName", "objectName"), new PropertyDescriptor((Object)"type", "type"), new PropertyDescriptor((Object)"value", "value"), new PropertyDescriptor((Object)"target", "target"), new PropertyDescriptor((Object)"depth", "depth"), new PropertyDescriptor((Object)"currentFrame", "currentFrame"), new PropertyDescriptor((Object)"className", "className"), new PropertyDescriptor((Object)"text", "text"), new PropertyDescriptor((Object)"title", "title"), new PropertyDescriptor((Object)"Location", "Location"), new PropertyDescriptor((Object)"tabIndex", "tabIndex"), new PropertyDescriptor((Object)"accInfo", "accInfo"), new PropertyDescriptor((Object)"isUIComponent", "isUIComponent"), new PropertyDescriptor((Object)"isOpaqueObject", "isOpaqueObject"), new PropertyDescriptor((Object)"isInputable", "isInputable"), new PropertyDescriptor((Object)"WMode", "WMode")};

    public FlashNodePropertySource(IASNode iASNode) {
        this.flashNode = iASNode;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        Set set;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < DESCRIPTORS.length) {
            if (this.getPropertyValue(DESCRIPTORS[n].getId()) != null) {
                arrayList.add(DESCRIPTORS[n]);
            }
            ++n;
        }
        if (DEBUG_MODE && (set = this.flashNode.getKeys()) != null) {
            for (String string : set) {
                arrayList.add(new PropertyDescriptor((Object)string, "[" + string + "]"));
            }
        }
        return arrayList.toArray(new IPropertyDescriptor[arrayList.size()]);
    }

    public Object getPropertyValue(Object object) {
        String string = null;
        if ("objectName".equals(object)) {
            string = this.flashNode.getObjectName();
        } else if ("type".equals(object)) {
            string = this.flashNode.getType();
        } else if ("value".equals(object)) {
            string = this.flashNode.getValue();
        } else if ("target".equals(object)) {
            string = this.flashNode.getTarget();
        } else if ("className".equals(object)) {
            string = this.flashNode.getClassName();
        } else if ("text".equals(object)) {
            string = this.flashNode.getText(false);
        } else if ("title".equals(object)) {
            string = this.flashNode.getTitle();
        } else if (PID_LOCATION.equals(object)) {
            try {
                double d = this.flashNode.getX();
                double d2 = this.flashNode.getY();
                double d3 = this.flashNode.getWidth();
                double d4 = this.flashNode.getHeight();
                if (Double.NaN != d) {
                    string = String.valueOf(d) + ", " + d2 + ", " + (d + d3) + ", " + (d2 + d4) + " (width=" + d3 + ", height=" + d4 + ")";
                }
            }
            catch (Exception exception) {}
        } else if ("WMode".equals(object)) {
            if (this.flashNode.getParent() == null) {
                string = this.flashNode.getPlayer().getWMode();
            }
        } else if (PID_TABINDEX.equals(object)) {
            if (this.flashNode.getTabIndex() > -1) {
                string = String.valueOf(this.flashNode.getTabIndex());
            }
        } else if ("accInfo".equals(object)) {
            ASAccInfo aSAccInfo = this.flashNode.getAccInfo();
            if (aSAccInfo != null) {
                AttributePropertySource attributePropertySource = new AttributePropertySource(null, aSAccInfo.toString());
                Set set = aSAccInfo.getKeys();
                for (String string2 : set) {
                    Object object2 = aSAccInfo.get(string2);
                    if (object2 instanceof Integer) {
                        int n = (Integer)object2;
                        if ("role".equals(string2)) {
                            object2 = MSAA.getRoleText((int)n);
                        } else if ("state".equals(string2)) {
                            object2 = MSAA.getStateText((int)n);
                        }
                    }
                    if (object2 instanceof String && ((String)object2).length() == 0) continue;
                    attributePropertySource.put((Object)string2, object2);
                }
                return attributePropertySource;
            }
        } else {
            Object object3 = this.flashNode.getObject(object.toString());
            if (object3 != null) {
                string = object3.toString();
            }
        }
        return string;
    }

    public boolean isPropertySet(Object object) {
        return false;
    }

    public void resetPropertyValue(Object object) {
    }

    public void setPropertyValue(Object object, Object object2) {
    }

    public static boolean isDebugMode() {
        return DEBUG_MODE;
    }

    public static void setDebugMode(boolean bl) {
        DEBUG_MODE = bl;
    }
}

