/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.blind.html.util;

import java.awt.Color;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.actf.util.logging.DebugPrintUtil;
import org.eclipse.actf.visualization.engines.blind.ParamBlind;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.DocumentCleaner;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.VisualizationNodeInfo;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.VisualizeMapDataImpl;
import org.eclipse.swt.graphics.RGB;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VisualizeColorUtil {
    private static final double WORD_JP = 0.1598360655737705;
    private Document result;
    private VisualizeMapDataImpl mapData;
    private List<VisualizationNodeInfo> nodeInfoList;
    private Map<Node, Node> linkMap;
    private ParamBlind param;

    public VisualizeColorUtil(Document result, VisualizeMapDataImpl mapData, ParamBlind param) {
        this.result = result;
        this.mapData = mapData;
        this.nodeInfoList = mapData.getNodeInfoList();
        this.linkMap = mapData.getIntraPageLinkMap();
        this.param = param;
    }

    public void setColorAll() {
        int changed = 0;
        DocumentCleaner.removeBgcolor(this.result);
        this.initHeadings();
        int i = 0;
        while (i < 10) {
            changed = this.calcWords();
            if (changed == 0) break;
            ++i;
        }
        this.calcTime();
        this.calcOrgTime();
        this.setColor();
    }

    private void setColor() {
        String strRGB = "#000000";
        if (this.param.bVisualizeTable) {
            NodeList nl = this.result.getElementsByTagName("head");
            try {
                Element headEl = (Element)nl.item(0);
                Element styleEl = this.result.createElement("style");
                styleEl.setAttribute("type", "text/css");
                strRGB = this.getRGBString(this.param.tableBorderColor, "#000000");
                Comment comment = this.result.createComment("td {border-width: 1px; border-style: dashed; border-color: " + strRGB + "}");
                styleEl.appendChild(comment);
                headEl.appendChild(styleEl);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (VisualizationNodeInfo info : this.nodeInfoList) {
            Node node = info.getNode();
            Element el = null;
            if (node.getNodeType() == 1) {
                el = (Element)node;
            } else if (node.getNodeType() == 3) {
                if (node.getParentNode().getNodeName().equals("textarea")) continue;
                el = this.result.createElement("span");
                node.getParentNode().insertBefore(el, node);
                if (info.isInvisible()) {
                    node.getParentNode().removeChild(node);
                } else {
                    el.appendChild(node);
                }
                Integer idObj = this.mapData.getIdOfNode(node);
                if (idObj != null) {
                    el.setAttribute("id", "id" + idObj.toString());
                }
            } else {
                DebugPrintUtil.devOrDebugPrintln((Object)"VisualizeColorUtil: unknown node in the nodeList");
                continue;
            }
            if (this.param.bColorizeTags && info.isHeading() | info.isTableHeader() | info.isLabel() | info.isIdRequiredInput()) {
                if (info.isHeading()) {
                    strRGB = this.getRGBString(this.param.headingTagsColor, "#33CCFF");
                }
                if (info.isTableHeader()) {
                    strRGB = this.getRGBString(this.param.tableHeaderColor, "#99FF00");
                }
                if (info.isLabel()) {
                    strRGB = this.getRGBString(this.param.labelTagsColor, "#FFFF00");
                }
                if (info.isIdRequiredInput()) {
                    strRGB = this.getRGBString(this.param.inputTagsColor, "#FF9900");
                }
                el.setAttribute("style", "color: black; background-image: none; background-color:" + strRGB);
                continue;
            }
            int time = info.getTime();
            if (time == 0) {
                switch (this.param.iLanguage) {
                    case 1: {
                        time = this.calcTimeJp(info.getTotalWords(), info.getTotalLines());
                        break;
                    }
                    default: {
                        time = this.calcTime(info.getTotalWords(), info.getTotalLines());
                    }
                }
                info.setTime(time);
            }
            if (this.param.bVisualizeTime) {
                el.setAttribute("style", "color: black; background-image: none; background-color: #" + this.calcColor(time, this.param.maxTimeColor, this.param.iMaxTime));
                continue;
            }
            el.setAttribute("style", "color: black; background-image: none; background-color: transparent");
        }
    }

    private String calcColor(int time, RGB rgb, int maxTime) {
        double timeD = time;
        double maxTimeD = maxTime;
        if (time >= maxTime) {
            Color color = new Color(rgb.red, rgb.green, rgb.blue);
            return Integer.toHexString(color.getRGB()).substring(2);
        }
        int colorValueR = (int)(255.0 - timeD / maxTimeD * (255.0 - (double)rgb.red));
        int colorValueG = (int)(255.0 - timeD / maxTimeD * (255.0 - (double)rgb.green));
        int colorValueB = (int)(255.0 - timeD / maxTimeD * (255.0 - (double)rgb.blue));
        Color color = new Color(colorValueR, colorValueG, colorValueB);
        return Integer.toHexString(color.getRGB()).substring(2);
    }

    private String getRGBString(RGB target, String defaultValue) {
        if (target != null) {
            return "rgb(" + target.red + "," + target.green + "," + target.blue + ")";
        }
        return defaultValue;
    }

    private void initHeadings() {
        int headingCount = 0;
        int curTotalWords = 0;
        int curTotalLines = 0;
        int size = this.nodeInfoList.size();
        int i = 0;
        while (i < size) {
            VisualizationNodeInfo curInfo = this.nodeInfoList.get(i);
            if (curInfo.isHeading()) {
                if (curInfo.getNode().getNodeName().matches("h[1-6]")) {
                    ++headingCount;
                }
                int tmpTotalWords = this.wordcountForHeading(headingCount);
                if (this.calcTime(curTotalWords, curTotalLines) >= this.calcTime(tmpTotalWords, 0)) {
                    curTotalWords = tmpTotalWords;
                    curTotalLines = 0;
                }
                curInfo.setTotalWords(curTotalWords);
                curInfo.setTotalLines(curTotalLines);
                curTotalWords += curInfo.getWords();
                curTotalLines += curInfo.getLines();
            } else if (this.calcTime(curInfo.getTotalWords(), curInfo.getTotalLines()) > this.calcTime(curTotalWords, curTotalLines)) {
                curInfo.setTotalWords(curTotalWords);
                curInfo.setTotalLines(curTotalLines);
                curTotalWords += curInfo.getWords();
                curTotalLines += curInfo.getLines();
            } else {
                curTotalWords = curInfo.getTotalWords() + curInfo.getWords();
                curTotalLines = curInfo.getTotalLines() + curInfo.getLines();
            }
            ++i;
        }
    }

    private void calcTime() {
        int size = this.nodeInfoList.size();
        int i = 0;
        while (i < size) {
            VisualizationNodeInfo curInfo = this.nodeInfoList.get(i);
            int time = this.calcTime(curInfo.getTotalWords(), curInfo.getTotalLines());
            curInfo.setTime(time);
            if (curInfo.getNode().getNodeName().matches("h[1-6]")) {
                this.replaceParentInfoTime(curInfo.getNode(), time);
            }
            ++i;
        }
    }

    private void calcOrgTime() {
        int size = this.nodeInfoList.size();
        int i = 0;
        while (i < size) {
            VisualizationNodeInfo curInfo = this.nodeInfoList.get(i);
            int time = this.calcTime(curInfo.getOrgTotalWords(), curInfo.getOrgTotalLines());
            curInfo.setOrgTime(time);
            ++i;
        }
    }

    private void replaceParentInfoTime(Node target, int time) {
        if (target != null) {
            Node parent = target.getParentNode();
            while (parent != null) {
                if (parent.getFirstChild() != target) break;
                VisualizationNodeInfo nodeInfo = this.mapData.getNodeInfo(parent);
                if (nodeInfo != null && nodeInfo.getTime() > time) {
                    nodeInfo.setTime(time);
                }
                target = parent;
                parent = target.getParentNode();
            }
        }
    }

    private void replaceParentInfoWord(Node target, int word, int line, int newTime) {
        if (target != null) {
            Node parent = target.getParentNode();
            while (parent != null) {
                if (parent.getFirstChild() != target) break;
                VisualizationNodeInfo nodeInfo = this.mapData.getNodeInfo(parent);
                if (nodeInfo != null && this.calcTime(nodeInfo.getTotalWords(), nodeInfo.getTotalLines()) > newTime) {
                    nodeInfo.setTotalWords(word);
                    nodeInfo.setTotalLines(line);
                }
                target = parent;
                parent = target.getParentNode();
            }
        }
    }

    private int calcWords() {
        int countChanged = 0;
        Set<Node> linkSet = this.linkMap.keySet();
        block0: for (Node fromNode : linkSet) {
            Node toNode = this.linkMap.get(fromNode);
            Integer fromIdInt = this.mapData.getIdOfNode(fromNode);
            Integer toIdInt = this.mapData.getIdOfNode(toNode);
            if (fromIdInt == null || toIdInt == null) continue;
            int fromId = fromIdInt;
            int toId = toIdInt;
            VisualizationNodeInfo fromInfo = this.nodeInfoList.get(fromId);
            if (fromInfo.getNode() != fromNode) {
                DebugPrintUtil.devOrDebugPrintln((Object)("from node does not exists: " + fromId + " " + fromNode));
                continue;
            }
            VisualizationNodeInfo toInfo = this.nodeInfoList.get(toId);
            if (toInfo.getNode() != toNode) {
                DebugPrintUtil.devOrDebugPrintln((Object)("to node does not exists: " + toId + " " + toNode));
                continue;
            }
            VisualizationNodeInfo curInfo = toInfo;
            int curId = toId;
            int curTotalWords = fromInfo.getTotalWords() + this.getWordcountFor2sec();
            int curTotalLines = fromInfo.getTotalLines();
            int newTime = this.calcTime(curTotalWords, curTotalLines);
            while (this.calcTime(curInfo.getTotalWords(), curInfo.getTotalLines()) > newTime) {
                ++countChanged;
                curInfo.setTotalWords(curTotalWords);
                curInfo.setTotalLines(curTotalLines);
                this.replaceParentInfoWord(curInfo.getNode(), curTotalWords, curTotalLines, newTime);
                if (++curId >= this.nodeInfoList.size()) continue block0;
                curInfo = this.nodeInfoList.get(curId);
                newTime = this.calcTime(curTotalWords += curInfo.getWords(), curTotalLines += curInfo.getLines());
            }
        }
        return countChanged;
    }

    private int calcTime(int words, int lines) {
        switch (this.param.iLanguage) {
            case 0: {
                return this.calcTimeEn(words, lines);
            }
            case 1: {
                return this.calcTimeJp(words, lines);
            }
        }
        return this.calcTimeEn(words, lines);
    }

    private int calcTimeEn(int words, int lines) {
        return (int)((double)words / 3.0 + (double)lines * 0.7);
    }

    private int calcTimeJp(int words, int lines) {
        return (int)((double)words * 0.1598360655737705 + (double)lines * 0.6);
    }

    private int wordcountForHeading(int headingNumber) {
        switch (this.param.iLanguage) {
            case 0: {
                return 6 * (headingNumber - 1) + 15;
            }
            case 1: {
                return 13 * (headingNumber - 1) + 31;
            }
        }
        return 6 * (headingNumber - 1) + 15;
    }

    private int getWordcountFor2sec() {
        switch (this.param.iLanguage) {
            case 0: {
                return 6;
            }
            case 1: {
                return 13;
            }
        }
        return 6;
    }
}

