/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.image;

import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import org.eclipse.actf.model.ui.ImagePositionInfo;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionException;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionType;
import org.eclipse.actf.visualization.engines.lowvision.image.ImageException;
import org.eclipse.actf.visualization.internal.engines.lowvision.DecisionMaker;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorIRGB;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.BinaryImage;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.ColorHistogram;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.ColorHistogramBin;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.ConnectedComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.ImageUtil;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Int2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.InteriorImageComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.LabeledImage;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.PageComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.PageImage;
import org.eclipse.actf.visualization.internal.engines.lowvision.operator.LowVisionFilter;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.ImageColorProblem;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblem;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblemException;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblemGroup;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteriorImage
extends PageComponent {
    public static final int UNSET = -1;
    public static final double THRESHOLD_MIN_IMAGE_COLOR_PROBLEM_PROBABILITY = 0.2;
    public static final int THRESHOLD_MIN_LARGE_COMPONENT_PIXELS = 100;
    public static final double THRESHOLD_MIN_LARGE_COMPONENT_OCCUPATION = 5.0E-4;
    int left = -1;
    int top = -1;
    Int2D pixel = null;
    int numLargeComponents = 0;
    InteriorImageComponent[] largeComponents = null;
    String url = null;
    Element image;

    public Element getImage() {
        return this.image;
    }

    public void setImageElement(Element image) {
        this.image = image;
    }

    public InteriorImage(PageImage _pi, int _x, int _y, int _width, int _height) {
        super((short)10, _pi);
        this.left = _x;
        this.top = _y;
        this.pixel = new Int2D(_width, _height);
        int j = 0;
        while (j < _height) {
            int i = 0;
            while (i < _width) {
                this.pixel.getData()[j][i] = _pi.pixel.getData()[j + this.top][i + this.left];
                ++i;
            }
            ++j;
        }
    }

    public InteriorImage(PageImage _pi, ImagePositionInfo _pos) {
        this(_pi, _pos.getX(), _pos.getY(), _pos.getWidth(), _pos.getHeight());
        this.url = _pos.getUrl();
    }

    InteriorImage(Int2D _i2d) {
        super((short)10, null);
        this.pixel = _i2d.deepCopy();
    }

    public InteriorImage(BufferedImage _bi) throws ImageException {
        super((short)10, null);
        this.pixel = ImageUtil.bufferedImageToInt2D(_bi);
    }

    public int getLeft() {
        return this.left;
    }

    public int getTop() {
        return this.top;
    }

    public String getUrl() {
        return this.url;
    }

    @Override
    public int getWidth() {
        return this.pixel.getWidth();
    }

    @Override
    public int getHeight() {
        return this.pixel.getHeight();
    }

    public String dumpLargeComponents() {
        if (this.numLargeComponents == 0) {
            return "There are no large components.";
        }
        String msg = "There are " + this.numLargeComponents + " large components.\n";
        int i = 0;
        while (i < this.numLargeComponents) {
            InteriorImageComponent curComponent = this.largeComponents[i];
            ColorIRGB curColor = new ColorIRGB(curComponent.getColor());
            msg = String.valueOf(msg) + i + ": ( " + curColor.getR() + ", " + curColor.getG() + ", " + curColor.getB() + ")\n";
            ++i;
        }
        return msg;
    }

    public void extractLargeComponents() {
        int histoSize;
        if (this.largeComponents != null) {
            return;
        }
        Vector<InteriorImageComponent> largeComponentVector = new Vector<InteriorImageComponent>();
        ColorHistogram histo = ColorHistogram.makeColorHistogram(this.pixel);
        int numProcessedColors = histoSize = histo.getSize();
        ColorHistogramBin[] histoArray = histo.getSortedArrayByOccurrence();
        int i = 0;
        while (i < histoSize) {
            if (histoArray[i].occurrence < 100) {
                numProcessedColors = i;
                break;
            }
            ++i;
        }
        int k = 0;
        while (k < numProcessedColors) {
            Vector<ConnectedComponent> currentVector = new Vector<ConnectedComponent>();
            int curColor = histoArray[k].color;
            BinaryImage binaryByColor = new BinaryImage(this.pixel, 0, curColor);
            LabeledImage curLabeledImage = new LabeledImage(binaryByColor, 0);
            int numComponents = curLabeledImage.numComponents;
            ConnectedComponent[] components = curLabeledImage.components;
            int l = 0;
            while (l < numComponents) {
                ConnectedComponent curCc = components[l];
                if (curCc.getCount() >= 100) {
                    currentVector.addElement(curCc);
                }
                ++l;
            }
            if (currentVector.size() > 0) {
                InteriorImageComponent iic = new InteriorImageComponent(this, curColor, currentVector);
                if (iic.occupation >= 5.0E-4) {
                    largeComponentVector.addElement(iic);
                }
                currentVector.removeAllElements();
            }
            ++k;
        }
        Collections.sort(largeComponentVector, new CompareByCount());
        this.numLargeComponents = largeComponentVector.size();
        if (this.numLargeComponents > 0) {
            this.largeComponents = new InteriorImageComponent[this.numLargeComponents];
            k = 0;
            while (k < this.numLargeComponents) {
                this.largeComponents[k] = (InteriorImageComponent)largeComponentVector.elementAt(k);
                ++k;
            }
            largeComponentVector.removeAllElements();
        }
    }

    public LowVisionProblemGroup[] checkColors(LowVisionType _lvType) throws ImageException {
        if (!_lvType.doChangeColors()) {
            return null;
        }
        this.extractLargeComponents();
        if (this.numLargeComponents <= 1) {
            return null;
        }
        Vector<LowVisionProblem> problemVector = new Vector<LowVisionProblem>();
        try {
            int k = 0;
            while (k < this.numLargeComponents - 1) {
                int l = k + 1;
                while (l < this.numLargeComponents) {
                    double probability;
                    int convColor2;
                    int convColor1;
                    InteriorImageComponent iic1 = this.largeComponents[k];
                    InteriorImageComponent iic2 = this.largeComponents[l];
                    int origColor1 = iic1.color;
                    int origColor2 = iic2.color;
                    if (DecisionMaker.distinguishableImageColors(origColor1, origColor2) && !DecisionMaker.distinguishableImageColors(convColor1 = _lvType.convertColor(origColor1), convColor2 = _lvType.convertColor(origColor2)) && !((probability = 1.0 - DecisionMaker.calcColorDistanceForImage(convColor1, convColor2)) < 0.2)) {
                        ImageColorProblem probl = new ImageColorProblem(this, _lvType, probability, iic1, iic2);
                        probl.setElement(this.image);
                        problemVector.addElement(probl);
                    }
                    ++l;
                }
                ++k;
            }
        }
        catch (Exception exception) {
            throw new ImageException("Exception occurred while checking colors.");
        }
        if (problemVector.size() > 0) {
            Collections.sort(problemVector, new CompareByProbability());
            LowVisionProblemGroup group = null;
            try {
                group = new LowVisionProblemGroup(problemVector);
            }
            catch (LowVisionProblemException lowVisionProblemException) {
                throw new ImageException("Error occurred while making an instance of LowVisionProblemGroup.");
            }
            LowVisionProblemGroup[] groupArray = new LowVisionProblemGroup[]{group};
            return groupArray;
        }
        return null;
    }

    private Vector<LowVisionProblemGroup> collectProblems(Vector<LowVisionProblem> _vec) throws ImageException {
        if (_vec == null || _vec.size() == 0) {
            return null;
        }
        Vector<LowVisionProblemGroup> answerVec = new Vector<LowVisionProblemGroup>();
        int curSize = _vec.size();
        while (curSize > 0) {
            LowVisionProblem curProb = _vec.elementAt(curSize - 1);
            _vec.removeElementAt(curSize - 1);
            Vector<LowVisionProblem> curVec = new Vector<LowVisionProblem>();
            curVec.addElement(curProb);
            short curType = curProb.getType();
            int k = curSize - 2;
            while (k >= 0) {
                LowVisionProblem tmpProb = _vec.elementAt(k);
                if (tmpProb.getType() == curType) {
                    _vec.removeElementAt(k);
                    curVec.addElement(tmpProb);
                }
                --k;
            }
            Collections.sort(curVec, new CompareByProbability());
            LowVisionProblemGroup curGroup = null;
            try {
                curGroup = new LowVisionProblemGroup(curVec);
            }
            catch (LowVisionProblemException lowVisionProblemException) {
                throw new ImageException("Error occurred while making an instance of LowVisionProblemGroup.");
            }
            answerVec.addElement(curGroup);
            curSize = _vec.size();
        }
        return answerVec;
    }

    public Int2D simulate(LowVisionType _lvType) throws ImageException {
        LowVisionFilter lvFilter = new LowVisionFilter(_lvType);
        try {
            Int2D simulatedPixel = ImageUtil.bufferedImageToInt2D(lvFilter.filter(this.pixel.toBufferedImage(), null));
            return simulatedPixel;
        }
        catch (LowVisionException lowVisionException) {
            throw new ImageException("Exception occurred while simulating an interiorImage");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CompareByCount
    implements Comparator<InteriorImageComponent> {
        private CompareByCount() {
        }

        @Override
        public int compare(InteriorImageComponent _o1, InteriorImageComponent _o2) {
            return _o2.count - _o1.count;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CompareByProbability
    implements Comparator<LowVisionProblem> {
        private CompareByProbability() {
        }

        @Override
        public int compare(LowVisionProblem _o1, LowVisionProblem _o2) {
            double diff = _o2.getProbability() - _o1.getProbability();
            if (diff > 0.0) {
                return 1;
            }
            if (diff < 0.0) {
                return -1;
            }
            return 0;
        }
    }
}

