/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.color;

import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorException;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorXYZ;

public class ColorLAB {
    private static final double THIRD = 0.3333333333333333;
    private float L;
    private float a;
    private float b;

    public ColorLAB(ColorXYZ _xyz) {
        float x = _xyz.getX();
        float y = _xyz.getY();
        float z = _xyz.getZ();
        this.L = y > 0.008856f ? (float)(116.0 * Math.pow(y, 0.3333333333333333) - 16.0) : 903.3f * y;
        double xThird = Math.pow(x, 0.3333333333333333);
        double yThird = Math.pow(y, 0.3333333333333333);
        double zThird = Math.pow(z, 0.3333333333333333);
        this.a = (float)(500.0 * (xThird - yThird));
        this.b = (float)(200.0 * (yThird - zThird));
    }

    public ColorLAB(float _l, float _a, float _b) throws ColorException {
        this.setL(_l);
        this.setA(_a);
        this.setB(_b);
    }

    public float getL() {
        return this.L;
    }

    public void setL(float _l) throws ColorException {
        if (_l < 0.0f || 100.0f < _l) {
            throw new ColorException("L is out of range: " + _l);
        }
        this.L = _l;
    }

    public float getA() {
        return this.a;
    }

    public void setA(float _a) {
        this.a = _a;
    }

    public float getB() {
        return this.b;
    }

    public void setB(float _b) {
        this.b = _b;
    }

    public ColorXYZ toXYZ() throws ColorException {
        float y = 0.0f;
        double y3 = 0.0;
        if (this.L > 8.0f) {
            y3 = (this.L + 16.0f) / 116.0f;
            y = (float)Math.pow(y3, 3.0);
        } else {
            y = this.L / 903.3f;
            y3 = Math.pow(y, 0.3333333333333333);
        }
        float x = (float)Math.pow((double)this.a / 500.0 + y3, 3.0);
        float z = (float)Math.pow(y3 - (double)this.b / 200.0, 3.0);
        return new ColorXYZ(x, y, z, false);
    }

    public float chroma() {
        return (float)Math.sqrt(this.a * this.a + this.b * this.b);
    }

    public double hueAngle() {
        return Math.atan2(this.b, this.a);
    }

    public static float deltaE(ColorLAB _c1, ColorLAB _c2) {
        double dL = _c1.L - _c2.L;
        double dA = _c1.a - _c2.a;
        double dB = _c1.b - _c2.b;
        return (float)Math.sqrt(dL * dL + dA * dA + dB * dB);
    }

    public static float deltaL(ColorLAB _c1, ColorLAB _c2) {
        return Math.abs(_c1.L - _c2.L);
    }

    public static float deltaH(ColorLAB _c1, ColorLAB _c2) {
        float dC = _c1.chroma() - _c2.chroma();
        float dA = _c1.a - _c2.a;
        float dB = _c1.b - _c2.b;
        return (float)Math.sqrt(dA * dA + dB * dB - dC * dC);
    }

    public static double deltaHueAngle(ColorLAB _c1, ColorLAB _c2) {
        double ha1 = _c1.hueAngle();
        double ha2 = _c2.hueAngle();
        if (Double.isNaN(ha1)) {
            return 0.0;
        }
        if (Double.isNaN(ha2)) {
            return 0.0;
        }
        double diff = Math.abs(ha1 - ha2);
        if (diff <= Math.PI) {
            return diff;
        }
        if (diff <= Math.PI * 2) {
            return Math.PI * 2 - diff;
        }
        return diff - Math.PI * 2;
    }

    public static double deltaHueAngleInDegree(ColorLAB _c1, ColorLAB _c2) {
        return ColorLAB.deltaHueAngle(_c1, _c2) * 180.0 / Math.PI;
    }
}

