/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.color;

import java.util.StringTokenizer;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorException;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorIRGB;

public class ColorCSS
extends ColorIRGB {
    private static final String DELIM = "/";
    static final int TRANSPARENT_R = 255;
    static final int TRANSPARENT_G = 255;
    static final int TRANSPARENT_B = 255;
    public static final int TRANSPARENT = 0xFFFFFF;
    public static final int DEFAULT_BACKGROUND_COLOR_INT = 0xFFFFFF;
    public static final int DEFAULT_COLOR_INT = 0;
    String originalString = "";

    public ColorCSS(String _s) throws ColorException {
        this(_s, true);
    }

    public ColorCSS(String _s, boolean _check) throws ColorException {
        this.originalString = !_s.endsWith(DELIM) ? _s : _s.substring(0, _s.length() - 1);
        if (this.originalString.indexOf(DELIM) == -1) {
            ColorIRGB ci = new ColorIRGB(this.originalString);
            this.R = ci.getR();
            this.G = ci.getG();
            this.B = ci.getB();
        } else {
            StringTokenizer st = new StringTokenizer(this.originalString.toLowerCase(), DELIM);
            boolean success = false;
            while (st.hasMoreTokens()) {
                String tmpStr = st.nextToken();
                if (tmpStr.equals("transparent")) continue;
                ColorIRGB ci = new ColorIRGB(tmpStr);
                this.R = ci.getR();
                this.G = ci.getG();
                this.B = ci.getB();
                success = true;
                break;
            }
            if (!success) {
                this.R = 255;
                this.G = 255;
                this.B = 255;
            }
        }
        if (_check) {
            this.rangeCheck();
        } else {
            this.rangeAdjust();
        }
    }

    public ColorCSS() throws ColorException {
        throw new ColorException("Constructor in wrong format.");
    }

    public ColorCSS(int _i) throws ColorException {
        throw new ColorException("Constructor in wrong format.");
    }

    public ColorCSS(int _i1, int _i2, int _i3) throws ColorException {
        throw new ColorException("Constructor in wrong format.");
    }

    public ColorCSS(int _i1, int _i2, int _i3, boolean _b) throws ColorException {
        throw new ColorException("Constructor in wrong format.");
    }

    private void rangeCheck() throws ColorException {
        if (this.R < 0 || this.R > 255) {
            throw new ColorException("R is out of range: " + this.R + ", inputString = " + this.originalString);
        }
        if (this.G < 0 || this.G > 255) {
            throw new ColorException("G is out of range: " + this.G + ", inputString = " + this.originalString);
        }
        if (this.B < 0 || this.B > 255) {
            throw new ColorException("B is out of range: " + this.B + ", inputString = " + this.originalString);
        }
    }

    private void rangeAdjust() {
        if (this.R < 0) {
            this.R = 0;
        } else if (this.R > 255) {
            this.R = 255;
        }
        if (this.G < 0) {
            this.G = 0;
        } else if (this.G > 255) {
            this.G = 255;
        }
        if (this.B < 0) {
            this.B = 0;
        } else if (this.B > 255) {
            this.B = 255;
        }
    }

    public String getOriginalString() {
        return this.originalString;
    }
}

