/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.engines.lowvision;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.actf.model.ui.ImagePositionInfo;
import org.eclipse.actf.model.ui.editor.browser.ICurrentStyles;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionException;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionIOException;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionType;
import org.eclipse.actf.visualization.engines.lowvision.image.IPageImage;
import org.eclipse.actf.visualization.engines.lowvision.image.ImageException;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.eval.problem.IProblemItemImage;
import org.eclipse.actf.visualization.internal.engines.lowvision.DebugUtil;
import org.eclipse.actf.visualization.internal.engines.lowvision.DecisionMaker;
import org.eclipse.actf.visualization.internal.engines.lowvision.LowVisionProblemConverter;
import org.eclipse.actf.visualization.internal.engines.lowvision.PageElement;
import org.eclipse.actf.visualization.internal.engines.lowvision.ScoreUtil;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Int2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.io.ImageWriter;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblem;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblemException;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblemGroup;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.ProblemItemLV;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageEvaluation {
    private static final int UNSET = -1;
    private IPageImage pageImage = null;
    private ImagePositionInfo[] tmpInteriorImagePositions = null;
    private PageElement[] pageElements = null;
    private String[] allowedForegroundColors = null;
    private String[] allowedBackgroundColors = null;
    private int pageWidth = -1;
    private int pageHeight = -1;
    private String overallRatingString = "";
    private String overallRatingImageString = "";
    private static final int PROBLEM_MAP_LENGTH = 100;

    public PageEvaluation(IPageImage _pageImage) {
        this.pageImage = _pageImage;
        if (this.pageImage != null) {
            if (this.pageImage.hasInteriorImageArraySet()) {
                try {
                    this.pageImage.extractCharacters();
                }
                catch (ImageException e) {
                    e.printStackTrace();
                }
            } else if (this.tmpInteriorImagePositions != null) {
                this.pageImage.setInteriorImagePosition(this.tmpInteriorImagePositions);
                this.tmpInteriorImagePositions = null;
                try {
                    this.pageImage.extractCharacters();
                }
                catch (ImageException e) {
                    e.printStackTrace();
                }
            }
            this.pageWidth = this.pageImage.getWidth();
            this.pageHeight = this.pageImage.getHeight();
        }
    }

    public IPageImage getPageImage() {
        return this.pageImage;
    }

    public ImagePositionInfo[] getInteriorImagePosition() {
        if (this.pageImage == null) {
            return null;
        }
        return this.pageImage.getInteriorImagePosition();
    }

    public void setInteriorImagePosition(ImagePositionInfo[] infoArray) {
        if (this.pageImage != null) {
            this.pageImage.setInteriorImagePosition(infoArray);
            try {
                this.pageImage.extractCharacters();
            }
            catch (ImageException e) {
                e.printStackTrace();
            }
        } else {
            this.tmpInteriorImagePositions = infoArray;
        }
    }

    public void setCurrentStyles(Map<String, ICurrentStyles> _styleMap) {
        Set<String> keySet = _styleMap.keySet();
        int len = keySet.size();
        this.pageElements = new PageElement[len];
        int i = 0;
        for (String key : keySet) {
            try {
                this.pageElements[i] = new PageElement(key, _styleMap.get(key));
            }
            catch (ImageException e) {
                e.printStackTrace();
                this.pageElements[i] = null;
            }
            ++i;
        }
    }

    public String[] getAllowedForegroundColors() {
        return this.allowedForegroundColors;
    }

    public String[] getAllowedBackgroundColors() {
        return this.allowedBackgroundColors;
    }

    public void setAllowedColors(String[] _fg, String[] _bg) {
        this.allowedForegroundColors = _fg;
        this.allowedBackgroundColors = _bg;
    }

    public List<IProblemItem> check(LowVisionType type, String urlS, int frameId) {
        List<IProblemItem> problemList = new ArrayList<IProblemItem>();
        if (this.pageImage != null) {
            try {
                problemList = this.pageImage.checkCharacters(type, urlS, frameId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.pageElements != null) {
            Vector<LowVisionProblemGroup> pageElementProblemVec = new Vector<LowVisionProblemGroup>();
            int len = this.pageElements.length;
            int i = 0;
            while (i < len) {
                PageElement curElement = this.pageElements[i];
                if (curElement != null) {
                    LowVisionProblem[] curProblemArray = curElement.check(type, this.allowedForegroundColors, this.allowedBackgroundColors);
                    int curLen = 0;
                    if (curProblemArray != null) {
                        curLen = curProblemArray.length;
                    }
                    int j = 0;
                    while (j < curLen) {
                        Vector<LowVisionProblem> tmpVec = new Vector<LowVisionProblem>();
                        tmpVec.addElement(curProblemArray[j]);
                        LowVisionProblemGroup lvpGroup = null;
                        try {
                            lvpGroup = new LowVisionProblemGroup(tmpVec);
                            pageElementProblemVec.addElement(lvpGroup);
                        }
                        catch (LowVisionProblemException lvpe) {
                            lvpe.printStackTrace();
                        }
                        ++j;
                    }
                }
                ++i;
            }
            int totalSize = pageElementProblemVec.size();
            LowVisionProblemGroup[] pageElementProblemArray = new LowVisionProblemGroup[totalSize];
            pageElementProblemVec.toArray(pageElementProblemArray);
            problemList.addAll(LowVisionProblemConverter.convert(pageElementProblemArray, urlS, frameId));
        }
        this.calcOverallRating(problemList);
        return problemList;
    }

    private void calcOverallRating(List<IProblemItem> problemList) {
        int totalSeverity = 0;
        for (IProblemItem item : problemList) {
            if (!(item instanceof ProblemItemLV)) continue;
            totalSeverity += ((IProblemItemImage)item).getSeverityLV();
        }
        this.overallRatingString = ScoreUtil.getScoreString(totalSeverity);
        this.overallRatingImageString = ScoreUtil.getScoreImageString(totalSeverity);
    }

    public void unsupportedModeReport(File targetFile) throws LowVisionException {
        StringBuffer sb = new StringBuffer();
        sb.append("<HTML>\n<HEAD>\n<TITLE>Report from LowVision Evaulator</TITLE>\n");
        sb.append("</HEAD><BODY>");
        sb.append("</BODY>\n</HTML>\n");
        if (targetFile != null) {
            try {
                PrintWriter pw = new PrintWriter(targetFile);
                pw.println(sb.toString());
                pw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new LowVisionException("Could not write to " + targetFile);
            }
        }
    }

    public void generateReport(String _path, String _htmlName, String _imgName, List<IProblemItem> _problemGroupArray) throws LowVisionException {
        String path;
        boolean doMakeProblemMap = true;
        if (this.pageImage == null) {
            doMakeProblemMap = false;
        }
        if (!(path = _path).endsWith(File.separator)) {
            path = String.valueOf(path) + File.separator;
        }
        String htmlPath = String.valueOf(path) + _htmlName;
        String imgPath = String.valueOf(path) + _imgName;
        int len = 0;
        if (_problemGroupArray != null) {
            len = _problemGroupArray.size();
        }
        Int2D scoreMap = null;
        if (doMakeProblemMap) {
            int scale;
            int shorter = this.pageWidth;
            if (this.pageWidth > this.pageHeight) {
                shorter = this.pageHeight;
            }
            if ((scale = (int)Math.ceil((double)shorter / 100.0)) <= 0) {
                throw new LowVisionException("scale is out of range: " + scale);
            }
            int mapWidth = (int)Math.ceil((double)this.pageWidth / (double)scale);
            int mapHeight = (int)Math.ceil((double)this.pageHeight / (double)scale);
            scoreMap = new Int2D(mapWidth, mapHeight);
            int k = 0;
            while (k < len) {
                if (_problemGroupArray.get(k) instanceof ProblemItemLV) {
                    int bottomLimit;
                    int groupY;
                    ProblemItemLV curProblem = (ProblemItemLV)_problemGroupArray.get(k);
                    int groupX = curProblem.getX();
                    if (groupX < 0) {
                        groupX = 0;
                    }
                    if ((groupY = curProblem.getY()) < 0) {
                        groupY = 0;
                    }
                    int groupWidth = curProblem.getWidth();
                    int groupHeight = curProblem.getHeight();
                    int rightLimit = groupX + groupWidth;
                    if (this.pageWidth < rightLimit) {
                        rightLimit = this.pageWidth;
                    }
                    if (this.pageHeight < (bottomLimit = groupY + groupHeight)) {
                        bottomLimit = this.pageHeight;
                    }
                    int j = groupY;
                    while (j < bottomLimit) {
                        int i = groupX;
                        while (i < rightLimit) {
                            try {
                                int[] nArray = scoreMap.getData()[j / scale];
                                int n = i / scale;
                                nArray[n] = nArray[n] + curProblem.getSeverityLV();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                DebugUtil.errMsg(this, "i=" + i + ", j=" + j + ", groupX=" + groupX + ", groupY=" + groupY + ", groupWidth=" + groupWidth + ", groupHeight=" + groupHeight + ", pageWidth=" + this.pageWidth + ", pageHeight=" + this.pageHeight);
                                throw new LowVisionException("Error while making problem map");
                            }
                            ++i;
                        }
                        ++j;
                    }
                }
                ++k;
            }
            double scaleDouble = scale * scale;
            int j = 0;
            while (j < mapHeight) {
                int i = 0;
                while (i < mapWidth) {
                    scoreMap.getData()[j][i] = DecisionMaker.getScoreMapColor((double)scoreMap.getData()[j][i] / 100.0 / scaleDouble);
                    ++i;
                }
                ++j;
            }
            try {
                ImageWriter.writeBufferedImage(scoreMap.toBufferedImage(), imgPath);
            }
            catch (LowVisionIOException lvioe) {
                lvioe.printStackTrace();
                throw new LowVisionException("An IO error occurred while writing the problem map file of this page.");
            }
        }
        scoreMap = null;
        StringBuffer sb = new StringBuffer();
        sb.append("<HTML>\n<HEAD>\n<TITLE>Report from LowVision Evaulator</TITLE>\n");
        sb.append("<STYLE type=\"text/css\">\n");
        sb.append("IMG {border:2 solid black}\n");
        sb.append("</STYLE>\n");
        sb.append("</HEAD><BODY>");
        sb.append("<DIV>\nOverall rating: <IMG src=\"./img/" + this.overallRatingImageString + "\" alt=\"" + this.overallRatingString + "\"></DIV>\n");
        sb.append("<HR>");
        sb.append("<DIV align=\"center\">\n");
        if (doMakeProblemMap) {
            sb.append("Problem Map<BR>\n");
            sb.append("<IMG src=\"" + _imgName + "\" alt=\"score map\" ");
            if (this.pageWidth >= this.pageHeight) {
                sb.append("width=\"75%\"");
            } else {
                sb.append("height=\"75%\"");
            }
            sb.append(">\n");
        } else {
            sb.append("Problem map is not available for this page.");
        }
        sb.append("</DIV>\n");
        sb.append("</BODY>\n</HTML>\n");
        try {
            PrintWriter pw = new PrintWriter(new FileWriter(htmlPath));
            pw.println(sb.toString());
            pw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new LowVisionException("Could not write to " + htmlPath);
        }
    }
}

