/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.presentation.ui.internal;

import java.io.File;
import java.util.List;
import org.eclipse.actf.mediator.IACTFReport;
import org.eclipse.actf.mediator.IACTFReportGenerator;
import org.eclipse.actf.mediator.Mediator;
import org.eclipse.actf.model.ui.IModelService;
import org.eclipse.actf.model.ui.ModelServiceImageCreator;
import org.eclipse.actf.model.ui.util.ModelServiceUtils;
import org.eclipse.actf.visualization.IVisualizationConst;
import org.eclipse.actf.visualization.engines.lowvision.image.IPageImage;
import org.eclipse.actf.visualization.engines.lowvision.image.PageImageFactory;
import org.eclipse.actf.visualization.presentation.eval.CheckResultPresentation;
import org.eclipse.actf.visualization.presentation.internal.Messages;
import org.eclipse.actf.visualization.presentation.internal.RoomPlugin;
import org.eclipse.actf.visualization.presentation.ui.internal.RoomView;
import org.eclipse.actf.visualization.presentation.util.ParamRoom;
import org.eclipse.actf.visualization.presentation.util.SimulateRoom;
import org.eclipse.actf.visualization.ui.IPositionSize;
import org.eclipse.actf.visualization.ui.IVisualizationView;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartControlRoom
implements IVisualizationConst {
    private static PartControlRoom INSTANCE = null;
    private static final CheckResultPresentation dummyResult = new CheckResultPresentation();
    private IPageImage targetPageImage;
    private RoomView roomView;
    private ParamRoom paramRoom;
    private Shell _shell;
    private boolean _isInSimulate;
    private CheckResultPresentation checkResult;
    private File vizResultFile;
    private String dumpImageFile;
    private IVisualizationView checker;
    private Mediator mediator = Mediator.getInstance();

    public static PartControlRoom getDefaultInstance() {
        return INSTANCE;
    }

    public PartControlRoom(IVisualizationView checker, Composite parent) {
        INSTANCE = this;
        this.checker = checker;
        this._shell = parent.getShell();
        this.paramRoom = new ParamRoom();
        this.roomView = new RoomView(parent);
        this._isInSimulate = false;
        try {
            File dumpImgFile = RoomPlugin.createTempFile("screenshot", ".bmp");
            this.dumpImageFile = dumpImgFile.getAbsolutePath();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doSimulate() {
        if (this._isInSimulate) {
            return;
        }
        this._isInSimulate = true;
        this._shell.setCursor(new Cursor((Device)this._shell.getDisplay(), 1));
        this.mediator.setReport((IACTFReportGenerator)this.checker, (IACTFReport)dummyResult);
        this.checkResult = new CheckResultPresentation();
        this.roomView.clearImage();
        this._shell.getDisplay().update();
        IModelService modelService = ModelServiceUtils.getActiveModelService();
        if (modelService == null) {
            return;
        }
        this.prepareInt2Ds(modelService);
    }

    private void prepareInt2Ds(IModelService modelService) {
        try {
            this.checker.setStatusMessage(Messages.PartRightRoom_dump_the_image_in_the_web_browser__26);
            ModelServiceImageCreator imgCreator = new ModelServiceImageCreator(modelService);
            imgCreator.getScreenImageAsBMP(this.dumpImageFile, false);
            this.targetPageImage = PageImageFactory.createPageImage((String)this.dumpImageFile);
            if (this.targetPageImage != null) {
                this.checker.setStatusMessage(Messages.PartRightRoom_begin_to_make_PageImage__2);
                this.doSimulateAfterHalf(modelService);
            } else {
                this._shell.setCursor(null);
                this._isInSimulate = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void doSimulateAfterHalf(IModelService modelService) {
        IPageImage pageImageWhole = this.targetPageImage;
        this.checker.setStatusMessage(Messages.PartRightRoom_prepare_Simulation_Image__29);
        this.paramRoom.setDisplayResolution(modelService.getTargetComposite().getSize().y);
        try {
            if (this.vizResultFile != null) {
                this.vizResultFile.delete();
            }
            this.vizResultFile = RoomPlugin.createTempFile("visualization", ".bmp");
            ImageData[] imageDataArray = SimulateRoom.doSimulate(pageImageWhole, this.paramRoom, this.vizResultFile.getAbsolutePath());
            if (imageDataArray.length > 0) {
                this.roomView.displayImage(imageDataArray[0], modelService);
            }
            imageDataArray = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String html = "";
        switch (this.paramRoom.getType()) {
            case 0: {
                html = Messages.report_small_url;
                break;
            }
            case 1: {
                html = Messages.report_middle_url;
                break;
            }
            case 2: {
                html = Messages.report_large_url;
            }
        }
        this.checkResult.setSummaryReportUrl(String.valueOf(RoomPlugin.getTempDirectory()) + "html" + File.separator + html);
        this.checkResult.setSummaryReportText("");
        Mediator.getInstance().setReport((IACTFReportGenerator)this.checker, (IACTFReport)this.checkResult);
        this.checker.setStatusMessage(Messages.PartRightRoom_simulation_of_current_page_is_over__8);
        this._shell.setCursor(null);
        this._isInSimulate = false;
    }

    public void setHighlightPositions(List<IPositionSize> infoPositionSizeList) {
        this.roomView.highlight(infoPositionSizeList);
    }

    public ParamRoom getParamLowVision() {
        return this.paramRoom;
    }

    public void setParamLowVision(ParamRoom vision) {
        this.paramRoom = vision;
    }

    public void setLVParamStatus() {
        if (!this._isInSimulate) {
            this.checker.setInfoMessage(this.paramRoom.toString());
        }
    }

    public void setCurrentModelService(IModelService modelService) {
        this.roomView.setCurrentModelService(modelService);
    }
}

