/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.gui.ui.views;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.actf.visualization.gui.internal.util.Messages;
import org.eclipse.actf.visualization.gui.msaa.properties.IPropertyInvoke;
import org.eclipse.actf.visualization.gui.ui.views.MSAAViewRegistory;
import org.eclipse.actf.visualization.gui.ui.views.PropertyTreeEntry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.views.properties.IPropertySource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyTreeViewer
extends TreeViewer {
    private Map<String, String> lastContents = new HashMap<String, String>();

    public PropertyTreeViewer(Composite parent, int style) {
        this(new Tree(parent, style));
    }

    public PropertyTreeViewer(Composite parent) {
        this(parent, 2818);
    }

    public PropertyTreeViewer(Tree tree) {
        super(tree);
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        TreeColumn nameColumn = new TreeColumn(tree, 0);
        nameColumn.setText(Messages.msaa_name);
        TreeColumn valueColumn = new TreeColumn(tree, 0);
        valueColumn.setText(Messages.msaa_value);
        tree.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Tree tree = PropertyTreeViewer.this.getTree();
                Rectangle area = tree.getClientArea();
                TreeColumn[] columns = tree.getColumns();
                if (area.width > 0) {
                    columns[0].setWidth(area.width * 40 / 100);
                    columns[1].setWidth(area.width - columns[0].getWidth() - 4);
                    tree.removeControlListener((ControlListener)this);
                }
            }
        });
        tree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (13 == e.keyCode) {
                    PropertyTreeViewer.this.invokeSource();
                }
            }
        });
    }

    private void invokeSource() {
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        if (selection.size() == 1) {
            this.invoke(selection.getFirstElement());
        }
    }

    public void invoke(Object element) {
        PropertyTreeEntry entry;
        IPropertySource source;
        if (element instanceof PropertyTreeEntry && (source = (entry = (PropertyTreeEntry)element).getPropertySource()) instanceof IPropertyInvoke) {
            MSAAViewRegistory.addUpdateRef();
            try {
                if (((IPropertyInvoke)source).invoke(entry.getId(), this.getControl().getShell())) {
                    this.refresh(element);
                }
            }
            finally {
                MSAAViewRegistory.releaseUpdateRef();
            }
        }
    }

    public void refresh() {
        this.setInput(this.getRoot());
    }

    protected void inputChanged(Object input, Object oldInput) {
        this.preservingSelection(new Runnable(){

            public void run() {
                Tree tree = (Tree)PropertyTreeViewer.this.getControl();
                tree.setRedraw(false);
                ISelection selected = PropertyTreeViewer.this.getSelection();
                Object[] expanded = PropertyTreeViewer.this.getExpandedElements();
                PropertyTreeViewer.this.lastContents.clear();
                PropertyTreeViewer.this.getContents(PropertyTreeViewer.this.lastContents, tree.getItems());
                PropertyTreeViewer.this.removeAll((Control)tree);
                tree.setData(PropertyTreeViewer.this.getRoot());
                PropertyTreeViewer.this.createChildren((Widget)tree);
                int i = 0;
                while (i < expanded.length) {
                    PropertyTreeViewer.this.setExpandedState(expanded[i], true);
                    ++i;
                }
                if (PropertyTreeViewer.this.getExpandedElements().length == 0 && tree.getItemCount() > 0) {
                    PropertyTreeViewer.this.setExpandedState(tree.getItem(0).getData(), true);
                }
                PropertyTreeViewer.this.setSelection(selected, true);
                tree.setRedraw(true);
            }
        });
    }

    private void getContents(Map<String, String> map, TreeItem[] items) {
        int i = 0;
        while (i < items.length) {
            TreeItem item = items[i];
            Object itemData = item.getData();
            if (itemData instanceof PropertyTreeEntry) {
                PropertyTreeEntry entry = (PropertyTreeEntry)itemData;
                map.put(entry.getPath(), item.getText(1));
            }
            this.getContents(map, item.getItems());
            ++i;
        }
    }

    public Map<String, String> getLastContents() {
        return this.lastContents;
    }
}

